/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1199", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class NestedBlocksCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1199";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1199");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCaseGroup(CaseGroupTree tree) {
        this.checkStatements(tree.body());
        super.visitCaseGroup(tree);
    }

    public void visitBlock(BlockTree tree) {
        this.checkStatements(tree.body());
        super.visitBlock(tree);
    }

    private void checkStatements(List<StatementTree> statements) {
        for (StatementTree statement : statements) {
            if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) continue;
            this.context.addIssue((Tree)statement, this.ruleKey, "Extract this nested code block into a method.");
        }
    }
}

