/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S1141", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class NestedTryCatchCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1141";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1141");
    private JavaFileScannerContext context;
    private int nestingLevel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.nestingLevel = 0;
        this.scan((Tree)context.getTree());
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resources());
        if (!tree.catches().isEmpty()) {
            ++this.nestingLevel;
            if (this.nestingLevel > 1) {
                this.context.addIssue((Tree)tree.block(), this.ruleKey, "Extract this nested try block into a separate method.");
            }
        }
        this.scan((Tree)tree.block());
        if (!tree.catches().isEmpty()) {
            --this.nestingLevel;
        }
        this.scan(tree.catches());
        this.scan((Tree)tree.finallyBlock());
    }
}

