/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1175", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ObjectFinalizeOverloadedCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.isFinalizeOverload(methodTree)) {
            this.addIssue((Tree)methodTree.simpleName(), "Rename this method to avoid any possible confusion with Object.finalize().");
        }
    }

    private boolean isFinalizeOverload(MethodTree methodTree) {
        return "finalize".equals(methodTree.simpleName().name()) && !methodTree.parameters().isEmpty();
    }
}

