/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="ObjectFinalizeOverridenCheck", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ObjectFinalizeOverridenCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.isFinalize(methodTree)) {
            this.addIssue((Tree)methodTree.simpleName(), "Do not override the Object.finalize() method.");
        }
    }

    private boolean isFinalize(MethodTree methodTree) {
        Tree returnType;
        if ("finalize".equals(methodTree.simpleName().name()) && (returnType = methodTree.returnType()) != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE})) {
            return "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }
}

