/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1174", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ObjectFinalizeOverridenNotPublicCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.isFinalize(methodTree) && this.isPublic(methodTree)) {
            this.addIssue((Tree)methodTree.simpleName(), "Make this finalize() method protected.");
        }
    }

    private boolean isPublic(MethodTree methodTree) {
        return methodTree.modifiers().modifiers().contains(Modifier.PUBLIC);
    }

    private boolean isFinalize(MethodTree methodTree) {
        Tree returnType;
        if ("finalize".equals(methodTree.simpleName().name()) && (returnType = methodTree.returnType()) != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE})) {
            return "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }
}

