/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1161", priority=Priority.MAJOR, tags={})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class OverrideAnnotationCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        if (this.isOverriding(methodTree) && !methodTree.isAnnotatedOverride()) {
            this.addIssue(tree, "Add the \"@Override\" annotation above this method signature");
        }
    }

    public boolean isOverriding(MethodTreeImpl methodTree) {
        return BooleanUtils.isTrue((Boolean)methodTree.isOverriding());
    }
}

