/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;

@Rule(key="S1228", priority=Priority.MAJOR, tags={"convention"})
public class PackageInfoCheck
implements JavaFileScanner {
    public static final String RULE_KEY = "S1228";
    private Set<File> directoriesWithPackageFile = Sets.newHashSet();
    private Set<File> directoriesWithoutPackageFile = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        File parentFile = context.getFile().getParentFile();
        if (!this.directoriesWithPackageFile.contains(parentFile)) {
            this.directoriesWithoutPackageFile.add(parentFile);
        }
        if ("package-info.java".equals(context.getFile().getName())) {
            this.directoriesWithoutPackageFile.remove(parentFile);
            this.directoriesWithPackageFile.add(parentFile);
        }
    }

    public Set<File> getDirectoriesWithoutPackageFile() {
        return this.directoriesWithoutPackageFile;
    }
}

