/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1168", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ReturnEmptyArrayyNotNullCheck
extends SubscriptionBaseVisitor {
    private static final Set<String> COLLECTION_TYPES = ImmutableSet.of((Object)"Collection", (Object)"BeanContext", (Object)"BeanContextServices", (Object)"BlockingDeque", (Object)"BlockingQueue", (Object)"Deque", (Object[])new String[]{"List", "NavigableSet", "Queue", "Set", "SortedSet", "AbstractCollection", "AbstractList", "AbstractQueue", "AbstractSequentialList", "AbstractSet", "ArrayBlockingQueue", "ArrayDeque", "ArrayList", "AttributeList", "BeanContextServicesSupport", "BeanContextSupport", "ConcurrentLinkedQueue", "ConcurrentSkipListSet", "CopyOnWriteArrayList", "CopyOnWriteArraySet", "DelayQueue", "EnumSet", "HashSet", "JobStateReasons", "LinkedBlockingDeque", "LinkedBlockingQueue", "LinkedHashSet", "LinkedList", "PriorityBlockingQueue", "PriorityQueue", "RoleList", "RoleUnresolvedList", "Stack", "SynchronousQueue", "TreeSet", "Vector"});
    private final Deque<Returns> returnType = Lists.newLinkedList();

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.returnType.clear();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR, (Object)Tree.Kind.RETURN_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)tree;
            this.returnType.push(Returns.getReturnType(methodTree.returnType()));
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            this.returnType.push(Returns.OTHERS);
        } else {
            ReturnStatementTree returnStatement = (ReturnStatementTree)tree;
            if (this.isReturningNull(returnStatement)) {
                if (this.returnType.peek().equals((Object)Returns.ARRAY)) {
                    this.addIssue((Tree)returnStatement, "Return an empty array instead of null.");
                } else if (this.returnType.peek().equals((Object)Returns.COLLECTION)) {
                    this.addIssue(tree, "Return an empty collection instead of null.");
                }
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.returnType.pop();
        }
    }

    private boolean isReturningNull(ReturnStatementTree tree) {
        return tree.expression() != null && tree.expression().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private static enum Returns {
        ARRAY,
        COLLECTION,
        OTHERS;


        public static Returns getReturnType(@Nullable Tree tree) {
            if (tree != null) {
                Tree returnType = tree;
                while (returnType.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
                    returnType = ((ParameterizedTypeTree)returnType).type();
                }
                if (returnType.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
                    return ARRAY;
                }
                if (Returns.isCollection(returnType)) {
                    return COLLECTION;
                }
            }
            return OTHERS;
        }

        private static boolean isCollection(Tree methodReturnType) {
            IdentifierTree identifierTree = null;
            if (methodReturnType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                identifierTree = (IdentifierTree)methodReturnType;
            } else if (methodReturnType.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                identifierTree = ((MemberSelectExpressionTree)methodReturnType).identifier();
            }
            return identifierTree != null && COLLECTION_TYPES.contains(identifierTree.name());
        }
    }
}

