/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S1143", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class ReturnInFinallyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1143";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1143");
    private final Deque<Boolean> isInFinally = new LinkedList<Boolean>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.isInFinally.clear();
        this.scan((Tree)context.getTree());
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resources());
        this.scan((Tree)tree.block());
        this.scan(tree.catches());
        if (tree.finallyBlock() != null) {
            this.isInFinally.push(true);
            this.scan((Tree)tree.finallyBlock());
            this.isInFinally.pop();
        }
    }

    public void visitMethod(MethodTree tree) {
        this.isInFinally.push(false);
        super.visitMethod(tree);
        this.isInFinally.pop();
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        if (this.isInFinally()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Remove this return statement from this finally block.");
        }
        super.visitReturnStatement(tree);
    }

    private boolean isInFinally() {
        return !this.isInFinally.isEmpty() && this.isInFinally.peek() != false;
    }
}

