/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2226", priority=Priority.CRITICAL, tags={"bug", "cert", "multi-threading", "struts"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ServletInstanceFieldCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variable = (VariableTree)tree;
        if (this.hasSemantic() && this.isOwnedByAServlet(variable) && !this.isStaticOrFinal(variable)) {
            this.addIssue(tree, "Remove this misleading mutable servlet instance fields or make it \"static\" and/or \"final\"");
        }
    }

    private boolean isOwnedByAServlet(VariableTree variable) {
        VariableTreeImpl vti = (VariableTreeImpl)variable;
        Symbol owner = vti.getSymbol().owner();
        if (owner.isKind(2)) {
            Symbol.TypeSymbol ownerType = (Symbol.TypeSymbol)owner;
            for (Type.ClassType classType : ownerType.superTypes()) {
                if (!classType.is("javax.servlet.http.HttpServlet") && !classType.is("org.apache.struts.action.Action")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStaticOrFinal(VariableTree variable) {
        List modifiers = variable.modifiers().modifiers();
        return modifiers.contains(Modifier.STATIC) || modifiers.contains(Modifier.FINAL);
    }
}

