/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1317", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class StringBufferAndBuilderWithCharCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1317";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1317");
    private JavaFileScannerContext context;
    private static final Set<String> TARGETED_CLASS = ImmutableSet.of((Object)"StringBuilder", (Object)"StringBuffer");

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitNewClass(NewClassTree tree) {
        ExpressionTree argument;
        if (TARGETED_CLASS.contains(StringBufferAndBuilderWithCharCheck.getclassName(tree)) && tree.arguments().size() == 1 && (argument = (ExpressionTree)tree.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.CHAR_LITERAL})) {
            String character = ((LiteralTree)argument).value();
            this.context.addIssue((Tree)tree, this.ruleKey, "Replace the constructor character parameter " + character + " with string parameter " + character.replace("'", "\"") + ".");
        }
    }

    public static String getclassName(NewClassTree newClasstree) {
        if (newClasstree.identifier().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)newClasstree.identifier()).identifier().name();
        }
        if (newClasstree.identifier().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)newClasstree.identifier()).name();
        }
        return null;
    }
}

