/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1219", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SwitchWithLabelsCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CASE_GROUP);
    }

    public void visitNode(Tree tree) {
        CaseGroupTree cgt = (CaseGroupTree)tree;
        for (StatementTree statementTree : cgt.body()) {
            if (!statementTree.is(new Tree.Kind[]{Tree.Kind.LABELED_STATEMENT})) continue;
            LabeledStatementTree lst = (LabeledStatementTree)statementTree;
            this.addIssue((Tree)lst, "Remove this misleading \"" + lst.label().name() + "\" label.");
        }
    }
}

