/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1479", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SwitchWithTooManyCasesCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAXIMUM_CASES = 30;
    @RuleProperty(key="maximum", defaultValue="30")
    public int maximumCases = 30;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        int cases = 0;
        for (CaseGroupTree caseGroupTree : switchStatementTree.cases()) {
            cases += caseGroupTree.labels().size();
        }
        if (cases > this.maximumCases) {
            this.addIssue((Tree)switchStatementTree, "Reduce the number of switch cases from " + cases + " to at most " + this.maximumCases + ".");
        }
    }
}

