/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.AstNode;
import java.util.Map;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AstNodeTokensMatcher;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1149", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SynchronizedClassUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    public static final String RULE_KEY = "S1149";
    private static final RuleKey RULE_KEY_FOR_REPOSITORY = RuleKey.of((String)"squid", (String)"S1149");
    private static final Map<String, String> REPLACEMENTS = ImmutableMap.builder().put((Object)"java.util.Vector", (Object)"\"ArrayList\" or \"LinkedList\"").put((Object)"java.util.Hashtable", (Object)"\"HashMap\"").put((Object)"java.lang.StringBuffer", (Object)"\"StringBuilder\"").put((Object)"java.util.Stack", (Object)"\"Deque\"").build();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        ExpressionTree init;
        super.visitVariable(tree);
        boolean hasIssueOnDeclaredType = this.reportIssueIfDeprecatedType(tree.type());
        if (!hasIssueOnDeclaredType && (init = tree.initializer()) != null && init.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            this.reportIssueIfDeprecatedType((Tree)tree.initializer());
        }
    }

    public void visitMethod(MethodTree tree) {
        this.scan((ListTree)tree.modifiers());
        this.scan(tree.typeParameters());
        this.scan(tree.returnType());
        this.scan((Tree)tree.defaultValue());
        this.scan((Tree)tree.block());
        if (!this.isOverriding(tree)) {
            for (VariableTree param : tree.parameters()) {
                this.reportIssueIfDeprecatedType(param.type());
            }
            this.reportIssueIfDeprecatedType(tree.returnType());
        }
    }

    public void visitClass(ClassTree tree) {
        super.visitClass(tree);
        for (Tree parent : tree.superInterfaces()) {
            this.reportIssueIfDeprecatedType(parent);
        }
    }

    private boolean reportIssueIfDeprecatedType(Tree tree) {
        if (tree == null) {
            return false;
        }
        Type symbolType = ((AbstractTypedTree)tree).getSymbolType();
        if (symbolType != null) {
            for (String forbiddenTypeName : REPLACEMENTS.keySet()) {
                if (!symbolType.is(forbiddenTypeName)) continue;
                this.reportIssue(tree, forbiddenTypeName);
                return true;
            }
        }
        return false;
    }

    private void reportIssue(Tree tree, String type) {
        String simpleTypeName = type.substring(type.lastIndexOf(46) + 1);
        this.context.addIssue(tree, RULE_KEY_FOR_REPOSITORY, "Replace the synchronized class \"" + simpleTypeName + "\" by an unsynchronized one such as " + REPLACEMENTS.get(type) + ".");
    }

    private boolean isOverriding(MethodTree tree) {
        for (AnnotationTree annotation : tree.modifiers().annotations()) {
            AstNode node = ((JavaTree)annotation).getAstNode();
            if (!AstNodeTokensMatcher.matches(node, "@Override")) continue;
            return true;
        }
        return false;
    }
}

