/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1162", priority=Priority.MAJOR, tags={"error-handling"})
public class ThrowCheckedExceptionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.THROW_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ThrowStatementTree throwStatementTree = (ThrowStatementTree)tree;
        Type symbolType = ((AbstractTypedTree)throwStatementTree.expression()).getSymbolType();
        if (symbolType.isTagged(10) && this.isCheckedException((Type.ClassType)symbolType)) {
            this.addIssue(tree, "Remove the usage of the checked exception '" + symbolType.getSymbol().getName() + "'.");
        }
    }

    private boolean isCheckedException(Type.ClassType symbolType) {
        Type.ClassType superType = symbolType;
        while (superType != null) {
            if (superType.is("java.lang.RuntimeException")) {
                return false;
            }
            if (superType.is("java.lang.Exception")) {
                return true;
            }
            superType = (Type.ClassType)superType.getSymbol().getSuperclass();
        }
        return false;
    }
}

