/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S1163", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ThrowsFromFinallyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE = "S1163";
    private static final RuleKey RULEKEY = RuleKey.of((String)"squid", (String)"S1163");
    private JavaFileScannerContext context;
    private int finallyLevel = 0;
    private boolean isInMethodWithinFinally;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resources());
        this.scan((Tree)tree.block());
        this.scan(tree.catches());
        ++this.finallyLevel;
        this.scan((Tree)tree.finallyBlock());
        --this.finallyLevel;
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        if (this.isInFinally() && !this.isInMethodWithinFinally) {
            this.context.addIssue((Tree)tree, RULEKEY, "Refactor this code to not throw exceptions in finally blocks.");
        }
        super.visitThrowStatement(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.isInMethodWithinFinally = this.isInFinally();
        super.visitMethod(tree);
        this.isInMethodWithinFinally = false;
    }

    private boolean isInFinally() {
        return this.finallyLevel > 0;
    }
}

