/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1160", priority=Priority.MAJOR, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ThrowsSeveralCheckedExceptionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List<String> thrownCheckedExceptions;
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && this.isPublic(methodTree) && !((MethodTreeImpl)methodTree).isMainMethod() && (thrownCheckedExceptions = this.getThrownCheckedExceptions(methodTree)).size() > 1 && this.isNotOverriden(methodTree)) {
            this.addIssue((Tree)methodTree, "Refactor this method to throw at most one checked exception instead of: " + Joiner.on((String)", ").join(thrownCheckedExceptions));
        }
    }

    private boolean isNotOverriden(MethodTree methodTree) {
        return BooleanUtils.isFalse((Boolean)((MethodTreeImpl)methodTree).isOverriding());
    }

    private boolean isPublic(MethodTree methodTree) {
        return ((MethodTreeImpl)methodTree).getSymbol().isPublic();
    }

    private List<String> getThrownCheckedExceptions(MethodTree methodTree) {
        List thrownClasses = ((MethodTreeImpl)methodTree).getSymbol().getThrownTypes();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol.TypeSymbol thrownClass : thrownClasses) {
            if (ThrowsSeveralCheckedExceptionCheck.isSubClassOfRuntimeException(thrownClass)) continue;
            builder.add((Object)(thrownClass.owner().getName() + "." + thrownClass.getName()));
        }
        return builder.build();
    }

    private static boolean isSubClassOfRuntimeException(Symbol.TypeSymbol thrownClass) {
        Symbol.TypeSymbol typeSymbol = thrownClass;
        while (typeSymbol != null) {
            if (ThrowsSeveralCheckedExceptionCheck.isRuntimeException(typeSymbol)) {
                return true;
            }
            Type superType = typeSymbol.getSuperclass();
            if (superType == null) {
                typeSymbol = null;
                continue;
            }
            typeSymbol = ((Type.ClassType)superType).getSymbol();
        }
        return false;
    }

    private static boolean isRuntimeException(Symbol.TypeSymbol thrownClass) {
        return "RuntimeException".equals(thrownClass.getName()) && "java.lang".equals(thrownClass.owner().getName());
    }
}

