/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2225", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ToStringReturningNullCheck
extends SubscriptionBaseVisitor {
    private boolean insideToString = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.RETURN_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.insideToString = this.isToStringDeclaration((MethodTree)tree);
        } else if (this.insideToString && this.isReturnNull((ReturnStatementTree)tree)) {
            this.addIssue(tree, "Return empty string instead.");
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.insideToString = false;
        }
    }

    private boolean isToStringDeclaration(MethodTree method) {
        return "toString".equals(method.simpleName().name()) && method.parameters().isEmpty();
    }

    private boolean isReturnNull(ReturnStatementTree returnStatement) {
        return returnStatement.expression().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }
}

