/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00104", priority=Priority.MAJOR, tags={"brain-overload"})
public class TooManyLinesOfCodeInFile_S00104_Check
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAXIMUM = 1000;
    @RuleProperty(key="maximumFileLocThreshold", defaultValue="1000")
    public int maximum = 1000;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitToken(SyntaxToken token) {
        int lines;
        InternalSyntaxToken internalSyntaxToken = (InternalSyntaxToken)token;
        if (internalSyntaxToken.isEOF() && (lines = internalSyntaxToken.getLine()) > this.maximum) {
            this.addIssueOnFile(MessageFormat.format("This file has {0} lines, which is greater than {1} authorized. Split it into smaller files.", lines, this.maximum));
        }
    }
}

