/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1172", priority=Priority.MAJOR, tags={"unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedMethodParameterCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1172";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1172");
    private JavaFileScannerContext context;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        if (this.semanticModel != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        if (tree.block() != null && !this.isExcluded(tree)) {
            ArrayList unused = Lists.newArrayList();
            for (VariableTree var : tree.parameters()) {
                Symbol sym = this.semanticModel.getSymbol((Tree)var);
                if (sym == null || !this.semanticModel.getUsages(sym).isEmpty()) continue;
                unused.add(var.simpleName().name());
            }
            if (!unused.isEmpty()) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Remove the unused method parameter(s) \"" + Joiner.on((String)",").join((Iterable)unused) + "\".");
            }
        }
    }

    private boolean isExcluded(MethodTree tree) {
        return ((MethodTreeImpl)tree).isMainMethod() || this.isOverriding(tree) || this.isSerializableMethod(tree) || this.isDesignedForExtension(tree);
    }

    private boolean isDesignedForExtension(MethodTree tree) {
        return !tree.modifiers().modifiers().contains(Modifier.PRIVATE) && this.isEmptyOrThrowStatement(tree.block());
    }

    private boolean isEmptyOrThrowStatement(BlockTree block) {
        return block.body().isEmpty() || block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT});
    }

    private boolean isSerializableMethod(MethodTree methodTree) {
        boolean result = false;
        if (methodTree.modifiers().modifiers().contains(Modifier.PRIVATE) && methodTree.parameters().size() == 1) {
            result |= "writeObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 1;
            result |= "readObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 2;
        }
        return result;
    }

    private boolean isOverriding(MethodTree tree) {
        return !BooleanUtils.isFalse((Boolean)((MethodTreeImpl)tree).isOverriding());
    }
}

