/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1848", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class UselessObjectCreationCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionStatementTree expressionStatement = (ExpressionStatementTree)tree;
        ExpressionTree expression = expressionStatement.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            String className = this.getClassName(((NewClassTree)expression).identifier());
            this.addIssue(tree, "Either remove this useless object instantiation of class \"" + className + "\" or use it");
        }
    }

    private String getClassName(Tree identifier) {
        String name = "";
        if (identifier.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            name = ((IdentifierTree)identifier).name();
        } else if (identifier.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            name = ((MemberSelectExpressionTree)identifier).identifier().name();
        } else if (identifier.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            name = this.getClassName(((ParameterizedTypeTree)identifier).type());
        }
        return name;
    }
}

