/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="UselessParenthesesCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UselessParenthesesCheck
extends SubscriptionBaseVisitor {
    private final Deque<Tree> parent = new LinkedList<Tree>();
    private static final Tree.Kind[] PARENT_EXPRESSION = new Tree.Kind[]{Tree.Kind.ANNOTATION, Tree.Kind.ARRAY_ACCESS_EXPRESSION, Tree.Kind.ASSERT_STATEMENT, Tree.Kind.CASE_LABEL, Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.DO_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.LAMBDA_EXPRESSION, Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD, Tree.Kind.NEW_ARRAY, Tree.Kind.NEW_CLASS, Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.RETURN_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.SYNCHRONIZED_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.VARIABLE, Tree.Kind.WHILE_STATEMENT};

    public void scanFile(JavaFileScannerContext context) {
        this.parent.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION}) && this.hasParentExpression(tree)) {
            this.addIssue(tree, "Remove those useless parentheses.");
        }
        this.parent.push(tree);
    }

    private boolean hasParentExpression(Tree tree) {
        Tree parentTree = this.parent.peek();
        if (parentTree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)parentTree;
            return !tree.equals(conditionalExpressionTree.condition()) && !tree.equals(conditionalExpressionTree.falseExpression());
        }
        if (parentTree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION}) && tree.equals(((ArrayAccessExpressionTree)parentTree).expression())) {
            return false;
        }
        return parentTree.is(PARENT_EXPRESSION);
    }

    public void leaveNode(Tree tree) {
        this.parent.pop();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.values());
    }
}

