/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jira.metrics;

import com.atlassian.jira.rpc.soap.client.JiraSoapService;
import com.atlassian.jira.rpc.soap.client.RemoteFilter;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.atlassian.jira.rpc.soap.client.RemotePriority;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.plugins.jira.metrics.JiraMetrics;
import org.sonar.plugins.jira.soap.JiraSoapSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Properties(value={@Property(key="sonar.jira.url.param", defaultValue="", name="Filter name", description="Case sensitive, example : SONAR-current-iteration", global=false, project=true, module=true)})
public class JiraSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JiraSensor.class);
    private final Settings settings;

    public JiraSensor(Settings settings) {
        this.settings = settings;
    }

    private String getServerUrl() {
        return this.settings.getString("sonar.jira.url");
    }

    private String getUsername() {
        return this.settings.getString("sonar.jira.login.secured");
    }

    private String getPassword() {
        return this.settings.getString("sonar.jira.password.secured");
    }

    private String getFilterName() {
        return this.settings.getString("sonar.jira.url.param");
    }

    public boolean shouldExecuteOnProject(Project project) {
        if (this.missingMandatoryParameters()) {
            LOG.info("JIRA issues sensor will not run as some parameters are missing.");
        }
        return project.isRoot() && !this.missingMandatoryParameters();
    }

    public void analyse(Project project, SensorContext context) {
        try {
            JiraSoapSession session = new JiraSoapSession(new URL(this.getServerUrl() + "/rpc/soap/jirasoapservice-v2"));
            session.connect(this.getUsername(), this.getPassword());
            JiraSoapService service = session.getJiraSoapService();
            String authToken = session.getAuthenticationToken();
            this.runAnalysis(context, service, authToken);
            session.disconnect();
        }
        catch (RemoteException e) {
            LOG.error("Error accessing Jira web service, please verify the parameters", (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOG.error("The specified JIRA URL is not valid: " + this.getServerUrl(), (Throwable)e);
        }
    }

    protected void runAnalysis(SensorContext context, JiraSoapService service, String authToken) throws RemoteException {
        Map<String, String> priorities = this.collectPriorities(service, authToken);
        RemoteFilter filter = this.findJiraFilter(service, authToken);
        Map<String, Integer> issuesByPriority = this.collectIssuesByPriority(service, authToken, filter);
        double total = 0.0;
        PropertiesBuilder distribution = new PropertiesBuilder();
        for (Map.Entry<String, Integer> entry : issuesByPriority.entrySet()) {
            total += (double)entry.getValue().intValue();
            distribution.add((Object)priorities.get(entry.getKey()), (Object)entry.getValue());
        }
        String url = this.getServerUrl() + "/secure/IssueNavigator.jspa?mode=hide&requestId=" + filter.getId();
        this.saveMeasures(context, url, total, distribution.buildData());
    }

    protected Map<String, String> collectPriorities(JiraSoapService service, String authToken) throws RemoteException {
        HashMap priorities = Maps.newHashMap();
        for (RemotePriority priority : service.getPriorities(authToken)) {
            priorities.put(priority.getId(), priority.getName());
        }
        return priorities;
    }

    protected Map<String, Integer> collectIssuesByPriority(JiraSoapService service, String authToken, RemoteFilter filter) throws RemoteException {
        RemoteIssue[] issues;
        HashMap issuesByPriority = Maps.newHashMap();
        for (RemoteIssue issue : issues = service.getIssuesFromFilter(authToken, filter.getId())) {
            String priority = issue.getPriority();
            if (!issuesByPriority.containsKey(priority)) {
                issuesByPriority.put(priority, 1);
                continue;
            }
            issuesByPriority.put(priority, (Integer)issuesByPriority.get(priority) + 1);
        }
        return issuesByPriority;
    }

    protected RemoteFilter findJiraFilter(JiraSoapService service, String authToken) throws RemoteException {
        RemoteFilter[] filters;
        RemoteFilter filter = null;
        try {
            filters = service.getFavouriteFilters(authToken);
        }
        catch (Exception e) {
            filters = service.getSavedFilters(authToken);
        }
        for (RemoteFilter f : filters) {
            if (!this.getFilterName().equals(f.getName())) continue;
            filter = f;
        }
        if (filter == null) {
            throw new IllegalStateException("Unable to find filter '" + this.getFilterName() + "' in JIRA");
        }
        return filter;
    }

    protected boolean missingMandatoryParameters() {
        return StringUtils.isEmpty((String)this.getServerUrl()) || StringUtils.isEmpty((String)this.getFilterName()) || StringUtils.isEmpty((String)this.getUsername()) || StringUtils.isEmpty((String)this.getPassword());
    }

    protected void saveMeasures(SensorContext context, String issueUrl, double totalPrioritiesCount, String priorityDistribution) {
        Measure issuesMeasure = new Measure(JiraMetrics.ISSUES, Double.valueOf(totalPrioritiesCount));
        issuesMeasure.setUrl(issueUrl);
        issuesMeasure.setData(priorityDistribution);
        context.saveMeasure(issuesMeasure);
    }

    public String toString() {
        return "JIRA issues sensor";
    }
}

