/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jira.reviews;

import com.atlassian.jira.rpc.soap.client.JiraSoapService;
import com.atlassian.jira.rpc.soap.client.RemoteAuthenticationException;
import com.atlassian.jira.rpc.soap.client.RemoteComponent;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.atlassian.jira.rpc.soap.client.RemotePermissionException;
import com.atlassian.jira.rpc.soap.client.RemoteValidationException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.ServerExtension;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issue;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jira.soap.JiraSoapSession;

@Properties(value={@Property(key="sonar.jira.soap.url", defaultValue="/rpc/soap/jirasoapservice-v2", name="SOAP base URL", description="Base URL for the SOAP API of the JIRA server", global=true, project=true), @Property(key="sonar.jira.project.key", defaultValue="", name="JIRA project key", description="Key of the JIRA project on which the issues should be created.", global=false, project=true), @Property(key="sonar.jira.info.priority.id", defaultValue="5", name="JIRA priority id for INFO", description="JIRA priority id used to create issues for Sonar violations with severity INFO. Default is 5 (Trivial).", global=true, project=true, type=PropertyType.INTEGER), @Property(key="sonar.jira.minor.priority.id", defaultValue="4", name="JIRA priority id for MINOR", description="JIRA priority id used to create issues for Sonar violations with severity MINOR. Default is 4 (Minor).", global=true, project=true, type=PropertyType.INTEGER), @Property(key="sonar.jira.major.priority.id", defaultValue="3", name="JIRA priority id for MAJOR", description="JIRA priority id used to create issues for Sonar violations with severity MAJOR. Default is 3 (Major).", global=true, project=true, type=PropertyType.INTEGER), @Property(key="sonar.jira.critical.priority.id", defaultValue="2", name="JIRA priority id for CRITICAL", description="JIRA priority id used to create issues for Sonar violations with severity CRITICAL. Default is 2 (Critical).", global=true, project=true, type=PropertyType.INTEGER), @Property(key="sonar.jira.blocker.priority.id", defaultValue="1", name="JIRA priority id for BLOCKER", description="JIRA priority id used to create issues for Sonar violations with severity BLOCKER. Default is 1 (Blocker).", global=true, project=true, type=PropertyType.INTEGER), @Property(key="sonar.jira.issue.type.id", defaultValue="3", name="Id of JIRA issue type", description="JIRA issue type id used to create issues for Sonar violations. Default is 3 (= Task in a default JIRA installation).", global=true, project=true, type=PropertyType.INTEGER), @Property(key="sonar.jira.issue.component.id", defaultValue="<none>", name="Id of JIRA component", description="JIRA component id used to create issues for Sonar violations. By default no component is set.", global=false, project=true, type=PropertyType.INTEGER)})
public class JiraIssueCreator
implements ServerExtension {
    private static final String QUOTE = "\n{quote}\n";
    private static final Logger LOG = LoggerFactory.getLogger(JiraIssueCreator.class);
    private final RuleFinder ruleFinder;

    public JiraIssueCreator(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public RemoteIssue createIssue(Issue sonarIssue, Settings settings) throws RemoteException {
        JiraSoapSession soapSession = this.createSoapSession(settings);
        return this.doCreateIssue(sonarIssue, soapSession, settings);
    }

    protected JiraSoapSession createSoapSession(Settings settings) {
        String jiraUrl = settings.getString("sonar.jira.url");
        String baseUrl = settings.getString("sonar.jira.soap.url");
        String completeUrl = jiraUrl + baseUrl;
        JiraSoapSession soapSession = null;
        try {
            soapSession = new JiraSoapSession(new URL(completeUrl));
        }
        catch (MalformedURLException e) {
            LOG.error("The JIRA server URL is not a valid one: " + completeUrl, (Throwable)e);
            throw new IllegalStateException("The JIRA server URL is not a valid one: " + completeUrl, e);
        }
        return soapSession;
    }

    protected RemoteIssue doCreateIssue(Issue sonarIssue, JiraSoapSession soapSession, Settings settings) {
        String jiraUrl = settings.getString("sonar.jira.url");
        String userName = settings.getString("sonar.jira.login.secured");
        String password = settings.getString("sonar.jira.password.secured");
        try {
            soapSession.connect(userName, password);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Impossible to connect to the JIRA server (" + jiraUrl + ").", e);
        }
        JiraSoapService jiraSoapService = soapSession.getJiraSoapService();
        String authToken = soapSession.getAuthenticationToken();
        RemoteIssue issue = this.initRemoteIssue(sonarIssue, settings);
        RemoteIssue returnedIssue = this.sendRequest(jiraSoapService, authToken, issue, jiraUrl, userName);
        String issueKey = returnedIssue.getKey();
        LOG.debug("Successfully created issue {}", (Object)issueKey);
        return returnedIssue;
    }

    protected RemoteIssue sendRequest(JiraSoapService jiraSoapService, String authToken, RemoteIssue issue, String jiraUrl, String userName) {
        try {
            return jiraSoapService.createIssue(authToken, issue);
        }
        catch (RemoteAuthenticationException e) {
            throw new IllegalStateException("Impossible to connect to the JIRA server (" + jiraUrl + ") because of invalid credentials for user " + userName, (Throwable)((Object)e));
        }
        catch (RemotePermissionException e) {
            throw new IllegalStateException("Impossible to create the issue on the JIRA server (" + jiraUrl + ") because user " + userName + " does not have enough rights.", (Throwable)((Object)e));
        }
        catch (RemoteValidationException e) {
            String message = StringUtils.removeStart((String)e.getFaultString(), (String)"com.atlassian.jira.rpc.exception.RemoteValidationException:").trim();
            throw new IllegalStateException("Impossible to create the issue on the JIRA server (" + jiraUrl + "): " + message, (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Impossible to create the issue on the JIRA server (" + jiraUrl + ")", e);
        }
    }

    protected RemoteIssue initRemoteIssue(Issue sonarIssue, Settings settings) {
        RemoteIssue issue = new RemoteIssue();
        issue.setProject(settings.getString("sonar.jira.project.key"));
        issue.setType(settings.getString("sonar.jira.issue.type.id"));
        issue.setPriority(this.sonarSeverityToJiraPriorityId(RulePriority.valueOf((String)sonarIssue.severity()), settings));
        issue.setSummary(this.generateIssueSummary(sonarIssue));
        issue.setDescription(this.generateIssueDescription(sonarIssue, settings));
        String componentId = settings.getString("sonar.jira.issue.component.id");
        if (!"<none>".equals(componentId)) {
            RemoteComponent rc = new RemoteComponent();
            rc.setId(componentId);
            issue.setComponents(new RemoteComponent[]{rc});
        }
        return issue;
    }

    protected String generateIssueSummary(Issue sonarIssue) {
        Rule rule = this.ruleFinder.findByKey(sonarIssue.ruleKey());
        StringBuilder summary = new StringBuilder("Sonar Issue #");
        summary.append(sonarIssue.key());
        if (rule != null && rule.getName() != null) {
            summary.append(" - ");
            summary.append(rule.getName().toString());
        }
        return summary.toString();
    }

    protected String generateIssueDescription(Issue sonarIssue, Settings settings) {
        StringBuilder description = new StringBuilder("Issue detail:");
        description.append(QUOTE);
        description.append(sonarIssue.message());
        description.append(QUOTE);
        description.append("\n\nCheck it on Sonar: ");
        description.append(settings.getString("sonar.core.serverBaseURL"));
        description.append("/issue/show/");
        description.append(sonarIssue.key());
        return description.toString();
    }

    protected String sonarSeverityToJiraPriorityId(RulePriority reviewSeverity, Settings settings) {
        String priorityId;
        switch (reviewSeverity) {
            case INFO: {
                priorityId = settings.getString("sonar.jira.info.priority.id");
                break;
            }
            case MINOR: {
                priorityId = settings.getString("sonar.jira.minor.priority.id");
                break;
            }
            case MAJOR: {
                priorityId = settings.getString("sonar.jira.major.priority.id");
                break;
            }
            case CRITICAL: {
                priorityId = settings.getString("sonar.jira.critical.priority.id");
                break;
            }
            case BLOCKER: {
                priorityId = settings.getString("sonar.jira.blocker.priority.id");
                break;
            }
            default: {
                throw new SonarException("Unable to convert review severity to JIRA priority: " + reviewSeverity);
            }
        }
        return priorityId;
    }
}

