/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jira.reviews;

import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.google.common.annotations.VisibleForTesting;
import java.rmi.RemoteException;
import org.sonar.api.ServerExtension;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.action.Function;
import org.sonar.plugins.jira.reviews.JiraIssueCreator;

public class LinkFunction
implements Function,
ServerExtension {
    private final JiraIssueCreator jiraIssueCreator;

    public LinkFunction(JiraIssueCreator jiraIssueCreator) {
        this.jiraIssueCreator = jiraIssueCreator;
    }

    public void execute(Function.Context context) {
        this.checkConditions(context.projectSettings());
        this.createJiraIssue(context);
    }

    protected void createJiraIssue(Function.Context context) {
        RemoteIssue issue;
        try {
            issue = this.jiraIssueCreator.createIssue(context.issue(), context.projectSettings());
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Impossible to create an issue on JIRA. A problem occured with the remote server: " + e.getMessage(), e);
        }
        this.createComment(issue, context);
        context.setAttribute("jira-issue-key", issue.getKey());
    }

    @VisibleForTesting
    void checkConditions(Settings settings) {
        this.checkProperty("sonar.jira.url", settings);
        this.checkProperty("sonar.jira.soap.url", settings);
        this.checkProperty("sonar.jira.login.secured", settings);
        this.checkProperty("sonar.jira.password.secured", settings);
        this.checkProperty("sonar.jira.project.key", settings);
        this.checkProperty("sonar.jira.info.priority.id", settings);
        this.checkProperty("sonar.jira.minor.priority.id", settings);
        this.checkProperty("sonar.jira.major.priority.id", settings);
        this.checkProperty("sonar.jira.critical.priority.id", settings);
        this.checkProperty("sonar.jira.blocker.priority.id", settings);
        this.checkProperty("sonar.jira.issue.type.id", settings);
        this.checkProperty("sonar.jira.issue.component.id", settings);
    }

    private void checkProperty(String property, Settings settings) {
        if (!settings.hasKey(property) && !settings.hasDefaultValue(property)) {
            throw new IllegalStateException("The JIRA property \"" + property + "\" must be defined before you can use the \"Link to Jira\" button");
        }
    }

    protected void createComment(RemoteIssue issue, Function.Context context) {
        context.addComment(this.generateCommentText(issue, context));
    }

    protected String generateCommentText(RemoteIssue issue, Function.Context context) {
        StringBuilder message = new StringBuilder();
        message.append("Issue linked to JIRA issue: ");
        message.append(context.projectSettings().getString("sonar.jira.url"));
        message.append("/browse/");
        message.append(issue.getKey());
        return message.toString();
    }
}

