/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jira.soap;

import com.atlassian.jira.rpc.soap.client.JiraSoapService;
import com.atlassian.jira.rpc.soap.client.JiraSoapServiceService;
import com.atlassian.jira.rpc.soap.client.JiraSoapServiceServiceLocator;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraSoapSession {
    private static final Logger LOG = LoggerFactory.getLogger(JiraSoapSession.class);
    private JiraSoapServiceService jiraSoapServiceLocator;
    private JiraSoapService jiraSoapService;
    private String token;
    private URL webServiceUrl;

    public JiraSoapSession(URL url) {
        this.webServiceUrl = url;
        this.jiraSoapServiceLocator = new JiraSoapServiceServiceLocator();
        try {
            this.jiraSoapService = this.jiraSoapServiceLocator.getJirasoapserviceV2(url);
            LOG.debug("SOAP Session service endpoint at " + url.toExternalForm());
        }
        catch (ServiceException e) {
            throw new IllegalStateException("ServiceException during JiraSoapService contruction", e);
        }
    }

    public void connect(String userName, String password) throws RemoteException {
        LOG.debug("Connnecting via SOAP as : {}", (Object)userName);
        this.token = this.getJiraSoapService().login(userName, password);
        LOG.debug("Connected");
    }

    public void disconnect() throws RemoteException {
        this.getJiraSoapService().logout(this.getAuthenticationToken());
    }

    public String getAuthenticationToken() {
        return this.token;
    }

    public JiraSoapService getJiraSoapService() {
        return this.jiraSoapService;
    }

    public JiraSoapServiceService getJiraSoapServiceLocator() {
        return this.jiraSoapServiceLocator;
    }

    public URL getWebServiceUrl() {
        return this.webServiceUrl;
    }
}

