/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.builder;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.report.pdf.entity.ComplexityDistribution;

public class ComplexityDistributionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ComplexityDistributionBuilder.class);
    private static ComplexityDistributionBuilder builder;
    private String sonarBaseUrl;

    private ComplexityDistributionBuilder(String sonarBaseUrl) {
        this.sonarBaseUrl = sonarBaseUrl;
    }

    public static ComplexityDistributionBuilder getInstance(String sonarBaseUrl) {
        if (builder == null) {
            return new ComplexityDistributionBuilder(sonarBaseUrl);
        }
        return builder;
    }

    public Image getGraphic(ComplexityDistribution complexityDistribution) {
        Image image = null;
        try {
            if (complexityDistribution.getyValues().length != 0) {
                image = Image.getInstance((String)(this.sonarBaseUrl + "/chart?cht=cvb&chdi=300x200&chca=" + complexityDistribution.formatXValues() + "&chov=y&chrav=y&chv=" + complexityDistribution.formatYValues() + "&chorgv=y&chcaaml=0.05&chseamu=0.2&chins=5&chcaamu=0.05&chcav=y&chc=777777,777777,777777,777777,777777,777777,777777"));
                image.setAlignment(5);
            }
        }
        catch (BadElementException e) {
            LOG.error("Can not generate complexity distribution image", (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOG.error("Can not generate complexity distribution image", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Can not generate complexity distribution image", (Throwable)e);
        }
        return image;
    }
}

