/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.builder;

import java.util.LinkedList;
import java.util.List;
import org.sonar.report.pdf.entity.FileInfo;
import org.sonar.wsclient.services.Resource;

public class FileInfoBuilder {
    public static List<FileInfo> initFromDocument(List<Resource> resources, int content) {
        LinkedList<FileInfo> fileInfoList = new LinkedList<FileInfo>();
        if (resources != null) {
            for (Resource fileNode : resources) {
                FileInfo fileInfo = new FileInfo();
                FileInfoBuilder.initFromNode(fileInfo, fileNode, content);
                if (!fileInfo.isContentSet(content)) continue;
                fileInfoList.add(fileInfo);
            }
        }
        return fileInfoList;
    }

    public static void initFromNode(FileInfo fileInfo, Resource fileNode, int content) {
        fileInfo.setKey(fileNode.getKey());
        fileInfo.setName(fileNode.getName());
        if (content == 1) {
            fileInfo.setViolations(fileNode.getMeasure("violations").getFormattedValue());
        } else if (content == 2) {
            fileInfo.setComplexity(fileNode.getMeasure("complexity").getFormattedValue());
        } else if (content == 3) {
            fileInfo.setDuplicatedLines(fileNode.getMeasure("duplicated_lines").getFormattedValue());
        }
    }
}

