/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.report.pdf.PDFReporter;
import org.sonar.report.pdf.builder.FileInfoBuilder;
import org.sonar.report.pdf.builder.MeasuresBuilder;
import org.sonar.report.pdf.builder.RuleBuilder;
import org.sonar.report.pdf.entity.FileInfo;
import org.sonar.report.pdf.entity.Measures;
import org.sonar.report.pdf.entity.Priority;
import org.sonar.report.pdf.entity.Project;
import org.sonar.report.pdf.entity.Rule;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Credentials;
import org.sonar.report.pdf.util.UrlPath;
import org.sonar.wsclient.Sonar;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class ProjectBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.sonar.PDF");
    private static ProjectBuilder builder;
    private Credentials credentials;
    private Sonar sonar;
    private PDFReporter pdfRefporter;

    public ProjectBuilder(Credentials credentials, Sonar sonar, PDFReporter pdfRefporter) {
        this.credentials = credentials;
        this.sonar = sonar;
        this.pdfRefporter = pdfRefporter;
    }

    public static ProjectBuilder getInstance(Credentials credentials, Sonar sonar, PDFReporter pdfRefporter) {
        if (builder == null) {
            return new ProjectBuilder(credentials, sonar, pdfRefporter);
        }
        return builder;
    }

    public Project initializeProject(String key) throws IOException, ReportException {
        Project project = new Project(key);
        LOG.info("Retrieving project info for " + project.getKey());
        ResourceQuery rq = ResourceQuery.create(project.getKey());
        rq.setDepth(0);
        Resource resource = this.sonar.find(rq);
        if (resource != null) {
            this.initFromNode(project, resource);
            this.initMeasures(project);
            this.initMostViolatedRules(project);
            this.initMostViolatedFiles(project);
            this.initMostComplexElements(project);
            this.initMostDuplicatedFiles(project);
            LOG.debug("Accessing Sonar: getting child projects");
            ResourceQuery resourceQueryChild = ResourceQuery.create(project.getKey());
            resourceQueryChild.setDepth(1);
            List<Resource> childNodes = this.sonar.findAll(resourceQueryChild);
            Iterator<Resource> it = childNodes.iterator();
            project.setSubprojects(new ArrayList<Project>(0));
            if (!it.hasNext()) {
                LOG.debug(project.getKey() + " project has no childs");
            }
            while (it.hasNext()) {
                Resource childNode = it.next();
                String scope = childNode.getScope();
                if (!scope.equals("PRJ")) continue;
                Project childProject = this.initializeProject(childNode.getKey());
                project.getSubprojects().add(childProject);
            }
        } else {
            LOG.info("Can't retrieve project info. Have you set username/password in Sonar settings?");
            throw new ReportException("Can't retrieve project info. Parent project node is empty. Authentication?");
        }
        return project;
    }

    private void initFromNode(Project project, Resource resourceNode) {
        project.setName(resourceNode.getName());
        project.setDescription(resourceNode.getDescription());
        project.setLinks(new LinkedList<String>());
        project.setSubprojects(new LinkedList<Project>());
        project.setMostViolatedRules(new LinkedList<Rule>());
        project.setMostComplexFiles(new LinkedList<FileInfo>());
        project.setMostDuplicatedFiles(new LinkedList<FileInfo>());
        project.setMostViolatedFiles(new LinkedList<FileInfo>());
    }

    private void initMeasures(Project project) throws IOException {
        LOG.info("    Retrieving measures");
        MeasuresBuilder measuresBuilder = MeasuresBuilder.getInstance(this.sonar);
        Measures measures = measuresBuilder.initMeasuresByProjectKey(project.getKey());
        project.setMeasures(measures);
    }

    private void initMostViolatedRules(Project project) throws IOException, ReportException {
        LOG.info("    Retrieving most violated rules");
        LOG.debug("Accessing Sonar: getting most violated rules");
        String[] priorities = Priority.getPrioritiesArray();
        int limit = 10;
        for (int i = priorities.length - 1; i >= 0 && limit > 0; --i) {
            ResourceQuery query = ResourceQuery.create(project.getKey());
            query.setDepth(0);
            query.setLimit(limit);
            query.setMetrics(UrlPath.getViolationsLevelPath(priorities[i]));
            query.setExcludeRules(false);
            Resource mostViolatedRulesByLevel = this.sonar.find(query);
            if (mostViolatedRulesByLevel != null) {
                int count = this.initMostViolatedRulesFromNode(project, mostViolatedRulesByLevel);
                LOG.debug("\t " + count + " " + priorities[i] + " violations");
                limit -= count;
                continue;
            }
            LOG.debug("There is not result on select //resources/resource");
            LOG.debug("There are no violations with level " + priorities[i]);
        }
    }

    private void initMostViolatedFiles(Project project) throws IOException {
        LOG.info("    Retrieving most violated files");
        LOG.debug("Accessing Sonar: getting most violated files");
        ResourceQuery resourceQuery = ResourceQuery.createForMetrics(project.getKey(), "violations");
        resourceQuery.setScopes("FIL");
        resourceQuery.setDepth(-1);
        resourceQuery.setLimit(5);
        List<Resource> resources = this.sonar.findAll(resourceQuery);
        List<FileInfo> fileInfoList = FileInfoBuilder.initFromDocument(resources, 1);
        project.setMostViolatedFiles(fileInfoList);
    }

    private void initMostComplexElements(Project project) throws IOException {
        LOG.info("    Retrieving most complex elements");
        LOG.debug("Accessing Sonar: getting most complex elements");
        ResourceQuery resourceQuery = ResourceQuery.createForMetrics(project.getKey(), "complexity");
        resourceQuery.setScopes("FIL");
        resourceQuery.setDepth(-1);
        resourceQuery.setLimit(5);
        List<Resource> resources = this.sonar.findAll(resourceQuery);
        project.setMostComplexFiles(FileInfoBuilder.initFromDocument(resources, 2));
    }

    private void initMostDuplicatedFiles(Project project) throws IOException {
        LOG.info("    Retrieving most duplicated files");
        LOG.debug("Accessing Sonar: getting most duplicated files");
        ResourceQuery resourceQuery = ResourceQuery.createForMetrics(project.getKey(), "duplicated_lines");
        resourceQuery.setScopes("FIL");
        resourceQuery.setDepth(-1);
        resourceQuery.setLimit(5);
        List<Resource> resources = this.sonar.findAll(resourceQuery);
        project.setMostDuplicatedFiles(FileInfoBuilder.initFromDocument(resources, 3));
    }

    private int initMostViolatedRulesFromNode(Project project, Resource mostViolatedNode) throws ReportException, IOException {
        RuleBuilder ruleBuilder = RuleBuilder.getInstance(this.credentials, this.sonar);
        List<Measure> measuresNode = mostViolatedNode.getMeasures();
        Iterator<Measure> it = measuresNode.iterator();
        if (!it.hasNext()) {
            LOG.warn("There is not result on select //resources/resource/msr");
        }
        int count = 0;
        while (it.hasNext()) {
            Measure measureNode = it.next();
            String formattedValueNode = measureNode.getFormattedValue();
            if (formattedValueNode.equals("0")) continue;
            Rule rule = ruleBuilder.initFromNode(measureNode);
            if ("workbook".equals(this.pdfRefporter.getReportType())) {
                ruleBuilder.loadViolatedResources(rule, rule.getKey(), project.getKey());
            }
            project.getMostViolatedRules().add(rule);
            ++count;
        }
        return count;
    }
}

