/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.util;

import java.io.File;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.report.pdf.batch.PDFPostJob;

public class FileUploader {
    private static final Logger LOG = LoggerFactory.getLogger(PDFPostJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(File file, String url) {
        PostMethod filePost = new PostMethod(url);
        try {
            LOG.info("Uploading PDF to server...");
            Part[] parts = new Part[]{new FilePart("upload", file)};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
            int status = client.executeMethod((HttpMethod)filePost);
            if (status == 200) {
                LOG.info("PDF uploaded.");
            } else {
                LOG.error("Something went wrong storing the PDF at server side. Status: " + status);
            }
        }
        catch (Exception ex) {
            LOG.error("Something went wrong storing the PDF at server side", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            filePost.releaseConnection();
        }
    }
}

