/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.connectors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.sonar.wsclient.Host;
import org.sonar.wsclient.connectors.ConnectionException;
import org.sonar.wsclient.connectors.Connector;
import org.sonar.wsclient.services.AbstractQuery;
import org.sonar.wsclient.services.CreateQuery;
import org.sonar.wsclient.services.DeleteQuery;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.UpdateQuery;

public class HttpClient3Connector
extends Connector {
    private static final int MAX_TOTAL_CONNECTIONS = 40;
    private static final int MAX_HOST_CONNECTIONS = 4;
    private final Host server;
    private HttpClient httpClient;

    public HttpClient3Connector(Host server) {
        this.server = server;
        this.createClient();
    }

    public HttpClient3Connector(Host server, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.server = server;
    }

    private void createClient() {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setConnectionTimeout(30000);
        params.setSoTimeout(30000);
        params.setDefaultMaxConnectionsPerHost(4);
        params.setMaxTotalConnections(40);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        this.configureCredentials();
    }

    private void configureCredentials() {
        if (this.server.getUsername() != null) {
            this.httpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.server.getUsername(), this.server.getPassword());
            this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public String execute(Query<?> query) {
        return this.executeRequest(this.newGetRequest(query));
    }

    @Override
    public String execute(CreateQuery<?> query) {
        return this.executeRequest(this.newPostRequest(query));
    }

    @Override
    public String execute(UpdateQuery<?> query) {
        return this.executeRequest(this.newPutRequest(query));
    }

    @Override
    public String execute(DeleteQuery query) {
        return this.executeRequest(this.newDeleteRequest(query));
    }

    private String executeRequest(HttpMethodBase method) {
        String json = null;
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                json = this.getResponseBodyAsString((HttpMethod)method);
            } else if (method.getStatusCode() != 404) {
                throw new ConnectionException("HTTP error: " + method.getStatusCode() + ", msg: " + method.getStatusText() + ", query: " + method);
            }
        }
        catch (HttpException e) {
            throw new ConnectionException("Query: " + method, e);
        }
        catch (IOException e) {
            throw new ConnectionException("Query: " + method, e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return json;
    }

    private HttpMethodBase newGetRequest(Query<?> query) {
        GetMethod method = new GetMethod(this.server.getHost() + query.getUrl());
        this.initRequest((HttpMethodBase)method, query);
        return method;
    }

    private HttpMethodBase newDeleteRequest(DeleteQuery query) {
        DeleteMethod method = new DeleteMethod(this.server.getHost() + query.getUrl());
        this.initRequest((HttpMethodBase)method, query);
        return method;
    }

    private HttpMethodBase newPostRequest(CreateQuery<?> query) {
        PostMethod method = new PostMethod(this.server.getHost() + query.getUrl());
        this.initRequest((HttpMethodBase)method, query);
        this.setRequestEntity((EntityEnclosingMethod)method, query);
        return method;
    }

    private HttpMethodBase newPutRequest(UpdateQuery<?> query) {
        PutMethod method = new PutMethod(this.server.getHost() + query.getUrl());
        this.initRequest((HttpMethodBase)method, query);
        this.setRequestEntity((EntityEnclosingMethod)method, query);
        return method;
    }

    private void setRequestEntity(EntityEnclosingMethod request, AbstractQuery<?> query) {
        if (query.getBody() != null) {
            try {
                request.setRequestEntity((RequestEntity)new StringRequestEntity(query.getBody(), "text/plain; charset=UTF-8", "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ConnectionException("Unsupported encoding", e);
            }
        }
    }

    private void initRequest(HttpMethodBase request, AbstractQuery query) {
        request.setRequestHeader("Accept", "application/json");
        if (query.getLocale() != null) {
            request.setRequestHeader("Accept-Language", query.getLocale());
        }
        request.getParams().setSoTimeout(query.getTimeoutMilliseconds());
    }

    private String getResponseBodyAsString(HttpMethod method) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream inputStream = method.getResponseBodyAsStream();
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new ConnectionException("Can not read response", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

