/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.DeleteQuery;
import org.sonar.wsclient.services.Property;

public class PropertyDeleteQuery
extends DeleteQuery {
    private String key;
    private String resourceKeyOrId;

    public PropertyDeleteQuery(String key) {
        this.key = key;
    }

    public PropertyDeleteQuery(String key, String resourceKeyOrId) {
        this.key = key;
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public PropertyDeleteQuery(Property property) {
        this.key = property.getKey();
    }

    public String getKey() {
        return this.key;
    }

    public PropertyDeleteQuery setKey(String key) {
        this.key = key;
        return this;
    }

    public String getResourceKeyOrId() {
        return this.resourceKeyOrId;
    }

    public PropertyDeleteQuery setResourceKeyOrId(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/properties");
        url.append("/").append(PropertyDeleteQuery.encode(this.key));
        url.append('?');
        PropertyDeleteQuery.appendUrlParameter(url, "resource", this.resourceKeyOrId);
        return url.toString();
    }
}

