/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Property;
import org.sonar.wsclient.services.UpdateQuery;

public class PropertyUpdateQuery
extends UpdateQuery<Property> {
    private String key;
    private String value;
    private String resourceKeyOrId;

    public PropertyUpdateQuery() {
    }

    public PropertyUpdateQuery(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public PropertyUpdateQuery(String key, String value, String resourceKeyOrId) {
        this.key = key;
        this.value = value;
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public PropertyUpdateQuery(Property property) {
        this.key = property.getKey();
        this.value = property.getValue();
    }

    public String getKey() {
        return this.key;
    }

    public PropertyUpdateQuery setKey(String key) {
        this.key = key;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public PropertyUpdateQuery setValue(String value) {
        this.value = value;
        return this;
    }

    public String getResourceKeyOrId() {
        return this.resourceKeyOrId;
    }

    public PropertyUpdateQuery setResourceKeyOrId(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/properties");
        url.append("/").append(PropertyUpdateQuery.encode(this.key));
        url.append('?');
        PropertyUpdateQuery.appendUrlParameter(url, "resource", this.resourceKeyOrId);
        return url.toString();
    }

    @Override
    public String getBody() {
        return this.value;
    }

    @Override
    public Class<Property> getModelClass() {
        return Property.class;
    }
}

