/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.user.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.wsclient.internal.HttpRequestFactory;
import org.sonar.wsclient.jsonsimple.JSONValue;
import org.sonar.wsclient.user.User;
import org.sonar.wsclient.user.UserClient;
import org.sonar.wsclient.user.UserParameters;
import org.sonar.wsclient.user.UserQuery;

public class DefaultUserClient
implements UserClient {
    private static final String BASE_URL = "/api/users/";
    private static final String SEARCH_URL = "/api/users/search";
    private static final String CREATE_URL = "/api/users/create";
    private static final String UPDATE_URL = "/api/users/update";
    private static final String DEACTIVATE_URL = "/api/users/deactivate";
    private final HttpRequestFactory requestFactory;

    public DefaultUserClient(HttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Override
    public List<User> find(UserQuery query) {
        String json = this.requestFactory.get(SEARCH_URL, query.urlParams());
        ArrayList<User> result = new ArrayList<User>();
        Map jsonRoot = (Map)JSONValue.parse(json);
        List jsonUsers = (List)jsonRoot.get("users");
        if (jsonUsers != null) {
            for (Map jsonUser : jsonUsers) {
                result.add(new User(jsonUser));
            }
        }
        return result;
    }

    @Override
    public User create(UserParameters userParameters) {
        String json = this.requestFactory.post(CREATE_URL, userParameters.urlParams());
        Map jsonRoot = (Map)JSONValue.parse(json);
        Map jsonUser = (Map)jsonRoot.get("user");
        return new User(jsonUser);
    }

    @Override
    public User update(UserParameters userParameters) {
        String json = this.requestFactory.post(UPDATE_URL, userParameters.urlParams());
        Map jsonRoot = (Map)JSONValue.parse(json);
        Map jsonUser = (Map)jsonRoot.get("user");
        return new User(jsonUser);
    }

    @Override
    public void deactivate(String login) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login", login);
        this.requestFactory.post(DEACTIVATE_URL, params);
    }
}

