/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core.configuration;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.resources.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhpPluginAbstractConfiguration {
    private static final String WINDOWS_BAT_SUFFIX = ".bat";
    private boolean analyzeOnly;
    private String argumentLine;
    private Project project = null;
    private String reportFileName;
    private String reportFileRelativePath;
    private boolean shouldRun;

    public String getArgumentLine() {
        return this.argumentLine;
    }

    protected abstract String getArgumentLineKey();

    protected abstract String getCommandLine();

    protected abstract String getDefaultArgumentLine();

    protected abstract String getDefaultReportFileName();

    protected abstract String getDefaultReportFilePath();

    public String getOsDependentToolScriptName() {
        if (this.isOsWindows()) {
            return this.getCommandLine() + WINDOWS_BAT_SUFFIX;
        }
        return this.getCommandLine();
    }

    public File getReportFile() {
        return new File(this.project.getFileSystem().getBuildDir(), this.reportFileRelativePath + File.separator + this.reportFileName);
    }

    public boolean isStringPropertySet(String key) {
        return !StringUtils.isBlank((String)this.project.getConfiguration().getString(key));
    }

    protected abstract String getReportFileNameKey();

    public String getReportFileRelativePath() {
        return this.reportFileRelativePath;
    }

    protected abstract String getReportFileRelativePathKey();

    protected abstract String getShouldAnalyzeOnlyKey();

    protected abstract String getShouldRunKey();

    public List<File> getSourceDirectories() {
        return this.project.getFileSystem().getSourceDirs();
    }

    public List<File> getTestDirectories() {
        return this.project.getFileSystem().getTestDirs();
    }

    protected void init(Project aProject) {
        this.project = aProject;
        if (this.getReportFileNameKey() != null) {
            this.reportFileName = this.project.getConfiguration().getString(this.getReportFileNameKey(), this.getDefaultReportFileName());
        }
        if (this.getReportFileRelativePathKey() != null) {
            this.reportFileRelativePath = this.project.getConfiguration().getString(this.getReportFileRelativePathKey(), this.getDefaultReportFilePath());
            File reportDirectory = new File(this.project.getFileSystem().getBuildDir().getAbsolutePath(), this.reportFileRelativePath);
            reportDirectory.mkdir();
        }
        if (this.getArgumentLineKey() != null) {
            this.argumentLine = this.project.getConfiguration().getString(this.getArgumentLineKey(), this.getDefaultArgumentLine());
        }
        if (this.getShouldAnalyzeOnlyKey() != null) {
            this.analyzeOnly = this.project.getConfiguration().getBoolean(this.getShouldAnalyzeOnlyKey(), this.shouldAnalyzeOnlyDefault());
        }
        if (this.getShouldRunKey() != null) {
            this.shouldRun = this.project.getConfiguration().getBoolean(this.getShouldRunKey(), this.shouldRunDefault());
        }
    }

    public boolean isAnalyseOnly() {
        return this.analyzeOnly;
    }

    protected boolean isOsWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public boolean isShouldRun() {
        return this.shouldRun;
    }

    protected final Project getProject() {
        return this.project;
    }

    protected final void setProject(Project project) {
        this.project = project;
    }

    protected abstract boolean shouldAnalyzeOnlyDefault();

    protected abstract boolean shouldRunDefault();
}

