/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core.executor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.php.core.executor.PhpPluginExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhpPluginAbstractExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PhpPluginAbstractExecutor.class);

    public void execute() {
        try {
            List<String> commandLine = this.getCommandLine();
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            LOG.info("Execute" + this.getExecutedTool() + " with command '{}'", (Object)this.prettyPrint(commandLine));
            Process p = builder.start();
            new AsyncPipe(p.getInputStream(), System.out).start();
            new AsyncPipe(p.getErrorStream(), System.err).start();
            LOG.info(this.getExecutedTool() + " ended with returned code '{}'.", (Object)p.waitFor());
        }
        catch (IOException e) {
            LOG.error("Can't execute the external tool", (Throwable)e);
            throw new PhpPluginExecutionException(e);
        }
        catch (InterruptedException e) {
            LOG.error("Async pipe interrupted: ", (Throwable)e);
        }
    }

    private String prettyPrint(List<String> commandLine) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = commandLine.iterator();
        while (iter.hasNext()) {
            String part = iter.next();
            sb.append(part);
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    protected abstract List<String> getCommandLine();

    protected abstract String getExecutedTool();

    static class AsyncPipe
    extends Thread {
        private static final int BUFFER_SIZE = 1024;
        private InputStream istrm;
        private OutputStream ostrm;

        public AsyncPipe(InputStream input, OutputStream output) {
            this.istrm = input;
            this.ostrm = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] buffer = new byte[1024];
                int length = this.istrm.read(buffer);
                while (length != -1) {
                    OutputStream outputStream = this.ostrm;
                    synchronized (outputStream) {
                        this.ostrm.write(buffer, 0, length);
                    }
                    length = this.istrm.read(buffer);
                }
            }
            catch (IOException e) {
                LOG.error("Can't execute the Async Pipe", (Throwable)e);
            }
        }
    }
}

