/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core.resources;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.DefaultProjectFileSystem;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.plugins.php.core.Php;
import org.sonar.plugins.php.core.resources.PhpPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpFile
extends Resource<PhpPackage> {
    private static final Logger LOG = LoggerFactory.getLogger(PhpFile.class);
    private static final String SEPARATOR = "/";
    private boolean unitTest;
    private String filename;
    private String packageKey;
    private String longName;
    private PhpPackage parent = null;

    public static PhpFile fromAbsolutePath(String path, List<File> sourceDirs, boolean unitTest) {
        return path == null ? null : PhpFile.fromIOFile(new File(path), sourceDirs, unitTest);
    }

    public static PhpFile fromAbsolutePath(String path, Project project) {
        PhpFile phpFile;
        PhpFile phpFile2 = phpFile = path == null ? null : PhpFile.fromIOFile(new File(path), project.getFileSystem().getSourceDirs(), false);
        if (phpFile == null) {
            phpFile = path == null ? null : PhpFile.fromIOFile(new File(path), project.getFileSystem().getTestDirs(), true);
        }
        return phpFile;
    }

    public static PhpFile fromIOFile(File file, List<File> dirs, boolean isUnitTest) {
        if (file == null || !Php.hasValidSuffixes(file.getName())) {
            return null;
        }
        String relativePath = DefaultProjectFileSystem.getRelativePath((File)file, dirs);
        if (relativePath != null) {
            String packageName = null;
            String className = relativePath;
            if (relativePath.indexOf(47) >= 0) {
                packageName = StringUtils.substringBeforeLast((String)relativePath, (String)SEPARATOR);
                packageName = StringUtils.replace((String)packageName, (String)SEPARATOR, (String)".");
                className = StringUtils.substringAfterLast((String)relativePath, (String)SEPARATOR);
            }
            className = StringUtils.substringBeforeLast((String)className, (String)".");
            return new PhpFile(packageName, className, isUnitTest);
        }
        return null;
    }

    public PhpFile(String key) {
        this(key, false);
    }

    public PhpFile(String key, boolean unitTest) {
        LOG.debug("key=[" + key + "], unitTest=[" + unitTest + "]");
        if (key == null) {
            throw new IllegalArgumentException("Php filename can not be null");
        }
        if (key.indexOf(36) > 0) {
            throw new IllegalArgumentException("Php inner classes are not supported yet : " + key);
        }
        this.unitTest = unitTest;
        String realKey = FilenameUtils.removeExtension((String)StringUtils.trim((String)key)).replaceAll(SEPARATOR, ".");
        if (realKey.contains(".")) {
            this.filename = StringUtils.substringAfterLast((String)realKey, (String)".");
            this.packageKey = StringUtils.substringBeforeLast((String)realKey, (String)".");
            this.longName = realKey;
        } else {
            this.filename = realKey;
            this.longName = realKey;
            this.packageKey = "(default)";
            realKey = realKey;
        }
        this.setKey(realKey);
    }

    public PhpFile(String packageName, String className) {
        this(packageName, className, false);
    }

    public PhpFile(String packageKey, String className, boolean isUnitTest) {
        String key;
        LOG.debug("aPackageName=[" + packageKey + "], className=[" + className + "], unitTest=[" + isUnitTest + "]");
        if (className == null) {
            throw new IllegalArgumentException("Php filename can not be null");
        }
        if (className.indexOf(36) > 0) {
            throw new IllegalArgumentException("Php inner classes are not supported yet : " + className);
        }
        this.filename = StringUtils.trim((String)className);
        if (StringUtils.isBlank((String)packageKey)) {
            this.packageKey = "(default)";
            this.longName = this.filename;
            key = this.filename;
        } else {
            this.packageKey = packageKey.trim();
            this.longName = key = this.packageKey + "." + this.filename;
        }
        this.setKey(key);
        this.unitTest = isUnitTest;
    }

    public String getScope() {
        return "FIL";
    }

    public String getQualifier() {
        return this.unitTest ? "UTS" : "CLA";
    }

    public String getDescription() {
        return null;
    }

    public Language getLanguage() {
        return Php.INSTANCE;
    }

    public String getName() {
        return this.filename;
    }

    public String getLongName() {
        return this.longName;
    }

    public PhpPackage getParent() {
        if (this.parent == null) {
            this.parent = new PhpPackage(this.packageKey);
        }
        return this.parent;
    }

    public boolean matchFilePattern(String antPattern) {
        String patternWithoutFileSuffix = StringUtils.substringBeforeLast((String)antPattern, (String)".");
        WildcardPattern matcher = WildcardPattern.create((String)patternWithoutFileSuffix, (String)".");
        return matcher.match(this.getKey());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("filename", (Object)this.filename);
        builder.append("longName", (Object)this.longName);
        builder.append("packageKey", (Object)this.packageKey);
        builder.append("parent", (Object)this.parent);
        builder.append("unitTest", this.unitTest);
        return builder.toString();
    }
}

