/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core.sensors;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.AbstractSourceImporter;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.php.core.Php;
import org.sonar.plugins.php.core.resources.PhpFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Phase(name=Phase.Name.PRE)
public class PhpSourceImporter
extends AbstractSourceImporter {
    private static final Logger LOG = LoggerFactory.getLogger(PhpSourceImporter.class);

    public PhpSourceImporter() {
        super((Language)Php.INSTANCE);
    }

    public void analyse(Project project, SensorContext context) {
        try {
            LOG.info("Importing files from project " + project.getName());
            this.doAnalyse(project, context);
        }
        catch (IOException e) {
            throw new SonarException("Parsing source files ended abnormaly", (Throwable)e);
        }
    }

    protected PhpFile createResource(File file, List<File> sourceDirs, boolean unitTest) {
        return file != null && !file.getName().contains("$") ? PhpFile.fromIOFile(file, sourceDirs, unitTest) : null;
    }

    protected void doAnalyse(Project project, SensorContext context) throws IOException {
        ProjectFileSystem fileSystem = project.getFileSystem();
        List sourceDirs = fileSystem.getSourceDirs();
        Language[] language = new Language[]{Php.INSTANCE};
        List sourceFiles = fileSystem.getSourceFiles(language);
        this.parseDirs(context, sourceFiles, sourceDirs, false, fileSystem.getSourceCharset());
        List testDirs = fileSystem.getTestDirs();
        List testFiles = fileSystem.getTestFiles(language);
        this.parseDirs(context, testFiles, testDirs, true, fileSystem.getSourceCharset());
        if (LOG.isInfoEnabled()) {
            for (File directory : sourceDirs) {
                LOG.info(directory.getName());
            }
            for (File directory : testDirs) {
                LOG.info(directory.getName());
            }
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("getLanguage()", (Object)this.getLanguage());
        builder.append("getClass()", ((Object)((Object)this)).getClass());
        return builder.toString();
    }
}

