/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.sensor;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.php.core.resources.PhpFile;
import org.sonar.plugins.php.core.resources.PhpPackage;
import org.sonar.plugins.php.phpunit.xml.CoverageNode;
import org.sonar.plugins.php.phpunit.xml.FileNode;
import org.sonar.plugins.php.phpunit.xml.LineNode;
import org.sonar.plugins.php.phpunit.xml.MetricsNode;
import org.sonar.plugins.php.phpunit.xml.ProjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpUnitCoverageResultParser {
    private static Logger logger = LoggerFactory.getLogger(PhpUnitCoverageResultParser.class);
    private static final String MSG_SAVE_MEASURES = "Saving {0} for {1} with value {2}";
    private static final double PERCENT = 100.0;
    private Project project;
    private SensorContext context;
    private Map<String, PackageNode> classByPackage;

    public PhpUnitCoverageResultParser(Project project, SensorContext context) {
        this.project = project;
        this.context = context;
        this.classByPackage = new HashMap<String, PackageNode>();
    }

    public void parse(File coverageReportFile) {
        if (coverageReportFile == null) {
            this.insertZeroWhenNoReports();
        } else {
            logger.info("Parsing file : {0}", (Object)coverageReportFile.getName());
            this.parseFile(this.context, coverageReportFile, this.project);
        }
    }

    private void insertZeroWhenNoReports() {
        this.context.saveMeasure(CoreMetrics.COVERAGE, Double.valueOf(0.0));
    }

    private void parseFile(SensorContext context, File coverageReportFile, Project project) {
        CoverageNode coverage = this.getCoverage(coverageReportFile);
        double percentage = 0.0;
        if (coverage.getProjects() != null && coverage.getProjects().size() > 0) {
            ProjectNode projectNode = coverage.getProjects().get(0);
            for (FileNode file : projectNode.getFiles()) {
                this.cumulateResults(file);
            }
            percentage = Double.valueOf(projectNode.getMetrics().getCoveredElements()) / Double.valueOf(projectNode.getMetrics().getTotalElementsCount());
            this.saveMeasures(this.classByPackage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(MessageFormat.format("Saving {0} for project {1} with value {2}", CoreMetrics.COVERAGE.getName(), project.getName(), this.convertPercentage(percentage)));
        }
        context.saveMeasure(CoreMetrics.COVERAGE, Double.valueOf(this.convertPercentage(percentage)));
    }

    private void cumulateResults(FileNode file) {
        PhpFile phpFile = PhpFile.fromAbsolutePath((String)file.getName(), (Project)this.project);
        if (phpFile == null) {
            logger.info(file.getName() + " can't be found amoung the project source directories");
            return;
        }
        PhpPackage phpPackage = phpFile.getParent();
        PackageNode packageNode = this.classByPackage.get(phpPackage.getName());
        if (packageNode == null) {
            packageNode = new PackageNode(phpPackage);
            this.classByPackage.put(phpPackage.getName(), packageNode);
        }
        packageNode.addClassByFileNode(file, phpFile);
    }

    private void saveMeasures(Map<String, PackageNode> classByPackage) {
        Collection<PackageNode> nodes = classByPackage.values();
        for (PackageNode node : nodes) {
            PhpPackage phpPackage = node.getPackage();
            double coveragePercent = 0.0;
            for (FileNode fileNode : node.getClassByFileNode().keySet()) {
                coveragePercent += this.saveClassMeasure(fileNode, node.getClassByFileNode().get(fileNode));
            }
            double percentageByPackage = coveragePercent / (double)node.getClassByFileNode().size();
            if (logger.isDebugEnabled()) {
                logger.debug(MessageFormat.format(MSG_SAVE_MEASURES, CoreMetrics.COVERAGE.getName(), this.convertPercentage(percentageByPackage)));
            }
            this.context.saveMeasure((Resource)phpPackage, CoreMetrics.COVERAGE, Double.valueOf(this.convertPercentage(percentageByPackage)));
        }
    }

    private double convertPercentage(Number percentage) {
        return ParsingUtils.scaleValue((double)(percentage.doubleValue() * 100.0));
    }

    private double saveClassMeasure(FileNode fileNode, PhpFile phpFile) {
        PropertiesBuilder lineHits = new PropertiesBuilder(CoreMetrics.COVERAGE_LINE_HITS_DATA);
        for (LineNode line : fileNode.getLines()) {
            this.saveLineMeasure(line, (PropertiesBuilder<Integer, Integer>)lineHits);
        }
        double methodCoveragePercent = Double.valueOf(fileNode.getMetrics().getCoveredElements()) / Double.valueOf(fileNode.getMetrics().getTotalElementsCount());
        double lineCoveragePercent = Double.valueOf(fileNode.getMetrics().getCoveredStatements()) / Double.valueOf(fileNode.getMetrics().getTotalStatementsCount());
        if (logger.isDebugEnabled()) {
            logger.debug(MessageFormat.format(MSG_SAVE_MEASURES, CoreMetrics.COVERAGE.getName(), phpFile.getName(), this.convertPercentage(methodCoveragePercent)));
            logger.debug(MessageFormat.format(MSG_SAVE_MEASURES, CoreMetrics.LINE_COVERAGE.getName(), phpFile.getName(), this.convertPercentage(lineCoveragePercent)));
            logger.debug(MessageFormat.format(MSG_SAVE_MEASURES, CoreMetrics.COVERAGE_LINE_HITS_DATA.getName(), phpFile.getName(), lineHits.buildData()));
        }
        this.context.saveMeasure((Resource)phpFile, CoreMetrics.COVERAGE, Double.valueOf(this.convertPercentage(methodCoveragePercent)));
        this.context.saveMeasure((Resource)phpFile, CoreMetrics.LINE_COVERAGE, Double.valueOf(this.convertPercentage(lineCoveragePercent)));
        this.context.saveMeasure((Resource)phpFile, lineHits.build());
        return methodCoveragePercent;
    }

    private void saveLineMeasure(LineNode line, PropertiesBuilder<Integer, Integer> lineHits) {
        lineHits.add((Object)line.getNum(), (Object)line.getCount());
    }

    private CoverageNode getCoverage(File coverageReportFile) {
        CoverageNode coverageNode;
        FileInputStream inputStream = null;
        try {
            XStream xstream = new XStream();
            xstream.aliasSystemAttribute("classType", "class");
            xstream.processAnnotations(CoverageNode.class);
            xstream.processAnnotations(ProjectNode.class);
            xstream.processAnnotations(FileNode.class);
            xstream.processAnnotations(MetricsNode.class);
            xstream.processAnnotations(LineNode.class);
            inputStream = new FileInputStream(coverageReportFile);
            coverageNode = (CoverageNode)xstream.fromXML((InputStream)inputStream);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Can't read pUnit report : " + coverageReportFile.getName(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return coverageNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageNode {
        private PhpPackage phpPackage;
        private Map<FileNode, PhpFile> classByFileNode;

        public Map<FileNode, PhpFile> getClassByFileNode() {
            return this.classByFileNode;
        }

        public PackageNode(PhpPackage phpPackage) {
            this.phpPackage = phpPackage;
            this.classByFileNode = new HashMap<FileNode, PhpFile>();
        }

        public void addClassByFileNode(FileNode fileNode, PhpFile phpFile) {
            this.classByFileNode.put(fileNode, phpFile);
        }

        public PhpPackage getPackage() {
            return this.phpPackage;
        }
    }
}

