/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.configuration;

import java.io.File;
import java.util.List;
import org.sonar.api.resources.Project;
import org.sonar.plugins.php.core.configuration.PhpPluginAbstractConfiguration;
import org.sonar.plugins.php.phpunit.configuration.PhpUnitConfigurationException;

public class PhpUnitConfiguration
extends PhpPluginAbstractConfiguration {
    public static final String DEFAULT_REPORT_FILE_NAME = "phpunit.xml";
    public static final String DEFAULT_REPORT_FILE_PATH = "/logs";
    public static final String REPORT_FILE_NAME_PROPERTY_KEY = "sonar.phpUnit.reportFileName";
    public static final String REPORT_FILE_RELATIVE_PATH_PROPERTY_KEY = "sonar.phpUnit.reportFileRelativePath";
    public static final String ANALYZE_ONLY_PROPERTY_KEY = "sonar.phpUnit.analyzeOnly";
    public static final String DEFAULT_ANALYZE_ONLY = "false";
    public static final String SHOULD_RUN_PROPERTY_KEY = "sonar.phpUnit.shouldRun";
    public static final String DEFAULT_SHOULD_RUN = "true";
    private static final String COMMAND_LINE = "phpunit";
    public static final String MAIN_TEST_FILE_PROPERTY_KEY = "sonar.phpUnit.mainTestClass";
    public static final String DEFAULT_MAIN_TEST_FILE = "AllTests.php";
    public static final String DEFAULT_COVERAGE_REPORT_FILE = "phpunit.coverage.xml";
    public static final String COVERAGE_REPORT_FILE_PROPERTY_KEY = "sonar.phpUnit.coverageReportFile";
    public static final String SHOULD_DEAL_WITH_COVERAGE_PROPERTY_KEY = "sonar.phpUnit.coverage.shouldRun";
    public static final String DEFAULT_SHOULD_DEAL_WITH_COVERAGE = "true";
    public static final String FILTER_OPTION = "--filter=";
    public static final String FILTER_PROPERTY_KEY = "sonar.phpUnit.filter";
    public static final String DEFAULT_FILTER = " ";
    public static final String BOOTSTRAP_OPTION = "--bootstrap=";
    public static final String BOOTSTRAP_PROPERTY_KEY = "sonar.phpUnit.bootstrap";
    public static final String DEFAULT_BOOTSTRAP = " ";
    public static final String CONFIGURATION_OPTION = "--configuration=";
    public static final String CONFIGURATION_PROPERTY_KEY = "sonar.phpUnit.configuration";
    public static final String DEFAULT_CONFIGURATION = " ";
    public static final String LOADER_OPTION = "--loader=";
    public static final String LOADER_PROPERTY_KEY = "sonar.phpUnit.loader";
    public static final String DEFAULT_LOADER = " ";
    public static final String GROUP_OPTION = "--group=";
    public static final String GROUP_PROPERTY_KEY = "sonar.phpUnit.group";
    public static final String DEFAULT_GROUP = " ";
    public static final String ARGUMENT_LINE_KEY = "sonar.phpUnit.argumentLine";
    public static final String DEFAULT_ARGUMENT_LINE = "";
    public static final String PROJECT_CLASS_DESCRIPTION = "The project main test class including the relativ path ie : \"/source/tests/AllTests.php\"";
    public static final String DEFAULT_ANALYZE_ONLY_DESCRIPTION = "If set to true the plugin will only parse the analyzis result file. If set to false the plugin will launch tool and parse result.";
    public static final String DEFAULT_SHOULD_RUN_DESCRIPTION = "If set to true the plugin will launch tool and parse result. If set to false the plugin will only parse the result file.";
    public static final String DEFAULT_SHOULD_DEAL_DESCRIPTION = "If set to true the plugin will also take php coverage files into account";

    protected PhpUnitConfiguration() {
    }

    public PhpUnitConfiguration(Project aProject) {
        super.init(aProject);
    }

    public String getMainTestClass() {
        String reportFileName = this.getProject().getConfiguration().getString(MAIN_TEST_FILE_PROPERTY_KEY, DEFAULT_MAIN_TEST_FILE);
        List directories = this.getTestDirectories();
        directories.addAll(this.getSourceDirectories());
        for (File directory : directories) {
            File file;
            if (!directory.isDirectory() || !(file = new File(directory.getAbsolutePath(), reportFileName)).exists()) continue;
            return file.getAbsolutePath();
        }
        File file = new File(this.getProject().getFileSystem().getBasedir(), reportFileName);
        if (!file.exists()) {
            throw new PhpUnitConfigurationException("The specificied main class file cannot be found: " + reportFileName);
        }
        return file.getAbsolutePath();
    }

    protected String getArgumentLineKey() {
        return null;
    }

    protected String getCommandLine() {
        return COMMAND_LINE;
    }

    protected String getDefaultArgumentLine() {
        return DEFAULT_ARGUMENT_LINE;
    }

    protected String getDefaultReportFileName() {
        return DEFAULT_REPORT_FILE_NAME;
    }

    protected String getDefaultReportFilePath() {
        return DEFAULT_REPORT_FILE_PATH;
    }

    protected String getReportFileNameKey() {
        return REPORT_FILE_NAME_PROPERTY_KEY;
    }

    protected String getReportFileRelativePathKey() {
        return REPORT_FILE_RELATIVE_PATH_PROPERTY_KEY;
    }

    protected String getShouldAnalyzeOnlyKey() {
        return ANALYZE_ONLY_PROPERTY_KEY;
    }

    protected String getShouldRunKey() {
        return SHOULD_RUN_PROPERTY_KEY;
    }

    protected boolean shouldAnalyzeOnlyDefault() {
        return Boolean.parseBoolean(DEFAULT_ANALYZE_ONLY);
    }

    protected boolean shouldRunDefault() {
        return Boolean.parseBoolean("true");
    }

    public boolean shouldRunCoverage() {
        return this.getProject().getConfiguration().getBoolean(SHOULD_DEAL_WITH_COVERAGE_PROPERTY_KEY, Boolean.parseBoolean("true"));
    }

    public File getCoverageReportFile() {
        return new File(this.getProject().getFileSystem().getBuildDir(), this.getReportFileRelativePath() + File.separator + this.getProject().getConfiguration().getString(COVERAGE_REPORT_FILE_PROPERTY_KEY, DEFAULT_COVERAGE_REPORT_FILE));
    }

    public String getFilter() {
        return this.getProject().getConfiguration().getString(FILTER_PROPERTY_KEY, " ");
    }

    public String getBootstrap() {
        return this.getProject().getConfiguration().getString(BOOTSTRAP_PROPERTY_KEY, " ");
    }

    public String getConfiguration() {
        return this.getProject().getConfiguration().getString(CONFIGURATION_PROPERTY_KEY, " ");
    }

    public String getLoader() {
        return this.getProject().getConfiguration().getString(LOADER_PROPERTY_KEY, " ");
    }

    public String getGroup() {
        return this.getProject().getConfiguration().getString(GROUP_PROPERTY_KEY, " ");
    }
}

