/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.sensor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.plugins.php.phpunit.sensor.PhpUnitTestReport;
import org.sonar.plugins.php.phpunit.xml.TestCase;
import org.sonar.plugins.php.phpunit.xml.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpTestSuiteReader {
    private static final String TESTSUITE_CLASS_NAME_SEPARATOR = "::";
    private Map<String, PhpUnitTestReport> reportsPerClass = new HashMap<String, PhpUnitTestReport>();

    private void cumulateTestCaseDetails(TestCase testCase, PhpUnitTestReport report) {
        if ("skipped".equals(testCase.getStatus())) {
            report.setSkipped(report.getSkipped() + 1);
        } else if ("failure".equals(testCase.getStatus())) {
            report.setFailures(report.getFailures() + 1);
        } else if ("error".equals(testCase.getStatus())) {
            report.setErrors(report.getErrors() + 1);
        }
        report.setTests(report.getTests() + 1);
        report.getDetails().add(testCase);
    }

    public List<PhpUnitTestReport> readSuite(TestSuite testSuite, String parentFileName) {
        List<TestCase> testCases;
        ArrayList<PhpUnitTestReport> result = new ArrayList<PhpUnitTestReport>();
        List<TestSuite> testSuites = testSuite.getTestSuites();
        if (testSuites != null) {
            for (TestSuite childSuite : testSuites) {
                this.readSuite(childSuite, testSuite.getFile());
            }
        }
        if ((testCases = testSuite.getTestCases()) != null) {
            for (TestCase testCase : testCases) {
                PhpUnitTestReport report;
                String testClassName = testCase.getClassName();
                if (testClassName == null) {
                    String name = testSuite.getName();
                    testClassName = name.substring(0, name.indexOf(TESTSUITE_CLASS_NAME_SEPARATOR));
                }
                if ((report = this.reportsPerClass.get(testClassName)) == null) {
                    report = new PhpUnitTestReport();
                    report.setDetails(new ArrayList<TestCase>());
                    report.setClassKey(testClassName);
                    String file = testCase.getFile();
                    if (file == null) {
                        file = parentFileName;
                    }
                    report.setFile(file);
                    this.reportsPerClass.put(testClassName, report);
                }
                if (parentFileName == null) {
                    report.setTime(testSuite.getTime());
                }
                this.cumulateTestCaseDetails(testCase, report);
            }
        }
        result.addAll(this.reportsPerClass.values());
        return result;
    }
}

