/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.sensor;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.resources.Project;
import org.sonar.plugins.php.core.executor.PhpPluginAbstractExecutor;
import org.sonar.plugins.php.phpunit.configuration.PhpUnitConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpUnitExecutor
extends PhpPluginAbstractExecutor {
    private final PhpUnitConfiguration config;
    private final Project project;

    public PhpUnitExecutor(PhpUnitConfiguration config, Project project) {
        this.config = config;
        this.project = project;
    }

    protected List<String> getCommandLine() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.config.getOsDependentToolScriptName());
        if (this.config.isStringPropertySet("sonar.phpUnit.filter")) {
            result.add("--filter=" + this.config.getFilter());
        } else if (this.config.isStringPropertySet("sonar.phpUnit.bootstrap")) {
            result.add("--bootstrap=" + this.config.getBootstrap());
        } else if (this.config.isStringPropertySet("sonar.phpUnit.configuration")) {
            result.add("--configuration=" + this.config.getConfiguration());
        } else if (this.config.isStringPropertySet("sonar.phpUnit.loader")) {
            result.add("--loader=" + this.config.getLoader());
        } else if (this.config.isStringPropertySet("sonar.phpUnit.group")) {
            result.add("--group=" + this.config.getGroup());
        } else if (this.config.isStringPropertySet("sonar.phpUnit.argumentLine")) {
            result.add(this.config.getArgumentLine());
        }
        result.add("--log-junit=" + this.config.getReportFile());
        if (this.config.shouldRunCoverage()) {
            result.add("--coverage-clover=" + this.config.getCoverageReportFile());
        }
        result.add(this.project.getName());
        result.add(this.config.getMainTestClass());
        return result;
    }

    protected String getExecutedTool() {
        return "PHP UNIT";
    }
}

