/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.sensor;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.php.core.resources.PhpFile;
import org.sonar.plugins.php.phpunit.sensor.PhpTestSuiteReader;
import org.sonar.plugins.php.phpunit.sensor.PhpUnitTestReport;
import org.sonar.plugins.php.phpunit.xml.TestCase;
import org.sonar.plugins.php.phpunit.xml.TestSuite;
import org.sonar.plugins.php.phpunit.xml.TestSuites;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpUnitResultParser {
    private static final double PERCENT = 100.0;
    private static final double MILLISECONDS = 1000.0;
    private static final int PRECISION = 1;
    private static Logger logger = LoggerFactory.getLogger(PhpUnitResultParser.class);
    private SensorContext context;
    private Project project;

    public PhpUnitResultParser(Project project, SensorContext context) {
        this.project = project;
        this.context = context;
    }

    private TestSuites getTestSuites(File report) {
        TestSuites testSuites;
        FileInputStream inputStream = null;
        try {
            XStream xstream = new XStream();
            xstream.aliasSystemAttribute("className", "class");
            xstream.processAnnotations(TestSuites.class);
            xstream.processAnnotations(TestSuite.class);
            xstream.processAnnotations(TestCase.class);
            inputStream = new FileInputStream(report);
            TestSuites testSuites2 = (TestSuites)xstream.fromXML((InputStream)inputStream);
            Log.debug((Object)("Tests suites: " + testSuites2));
            testSuites = testSuites2;
        }
        catch (IOException e) {
            try {
                throw new SonarException("Can't read pUnit report : " + report.getName(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return testSuites;
    }

    private PhpFile getUnitTestResource(PhpUnitTestReport report, Project project) {
        return PhpFile.fromAbsolutePath((String)report.getFile(), (List)project.getFileSystem().getTestDirs(), (boolean)true);
    }

    private void insertZeroWhenNoReports(Project project, SensorContext context) {
        context.saveMeasure(CoreMetrics.TESTS, Double.valueOf(0.0));
    }

    protected void parse(File reportFile) {
        if (reportFile == null) {
            this.insertZeroWhenNoReports(this.project, this.context);
        } else {
            logger.info("Parsing file : ", (Object)reportFile.getName());
            this.parseFile(this.context, reportFile, this.project);
        }
    }

    private void parseFile(SensorContext context, File report, Project project) {
        TestSuites testSuites = this.getTestSuites(report);
        List<PhpUnitTestReport> fileReports = this.readSuites(testSuites);
        for (PhpUnitTestReport fileReport : fileReports) {
            this.saveTestReportMeasures(context, project, fileReport);
        }
    }

    public List<PhpUnitTestReport> readSuites(TestSuites testSuites) {
        ArrayList<PhpUnitTestReport> result = new ArrayList<PhpUnitTestReport>();
        for (TestSuite testSuite : testSuites.getTestSuites()) {
            PhpTestSuiteReader reader = new PhpTestSuiteReader();
            List<PhpUnitTestReport> list = reader.readSuite(testSuite, null);
            result.addAll(list);
        }
        return result;
    }

    private void saveClassMeasure(SensorContext context, PhpUnitTestReport fileReport, Metric metric, double value, Project project) {
        if (!Double.isNaN(value)) {
            context.saveMeasure((Resource)this.getUnitTestResource(fileReport, project), metric, Double.valueOf(value));
        }
    }

    private void saveTestReportMeasures(SensorContext context, Project project, PhpUnitTestReport fileReport) {
        if (!fileReport.isValid()) {
            return;
        }
        if (fileReport.getTests() > 0) {
            double testsCount = fileReport.getTests() - fileReport.getSkipped();
            if (fileReport.getSkipped() > 0) {
                this.saveClassMeasure(context, fileReport, CoreMetrics.SKIPPED_TESTS, fileReport.getSkipped(), project);
            }
            double duration = Math.round(fileReport.getTime() * 1000.0);
            this.saveClassMeasure(context, fileReport, CoreMetrics.TEST_EXECUTION_TIME, duration, project);
            this.saveClassMeasure(context, fileReport, CoreMetrics.TESTS, testsCount, project);
            this.saveClassMeasure(context, fileReport, CoreMetrics.TEST_ERRORS, fileReport.getErrors(), project);
            this.saveClassMeasure(context, fileReport, CoreMetrics.TEST_FAILURES, fileReport.getFailures(), project);
            double passedTests = testsCount - (double)fileReport.getErrors() - (double)fileReport.getFailures();
            if (testsCount > 0.0) {
                double percentage = passedTests * 100.0 / testsCount;
                this.saveClassMeasure(context, fileReport, CoreMetrics.TEST_SUCCESS_DENSITY, ParsingUtils.scaleValue((double)percentage), project);
            }
            this.saveTestsDetails(context, fileReport, project);
        }
    }

    private void saveTestsDetails(SensorContext context, PhpUnitTestReport fileReport, Project project) {
        StringBuilder details = new StringBuilder();
        details.append("<tests-details>");
        for (TestCase detail : fileReport.getDetails()) {
            double time = ParsingUtils.scaleValue((double)(detail.getTime() * 1000.0), (int)1);
            details.append("<testcase status=\"").append(detail.getStatus()).append("\" time=\"");
            details.append(time).append("\" name=\"").append(detail.getName().replaceAll(" ", "_")).append("\"");
            boolean isError = "error".equals(detail.getStatus());
            if (isError || "failure".equals(detail.getStatus())) {
                details.append(">").append(isError ? "<error message=\"" : "<failure message=\"");
                details.append(StringEscapeUtils.escapeXml((String)detail.getErrorMessage())).append("\"><![CDATA[");
                details.append(StringEscapeUtils.escapeXml((String)detail.getStackTrace())).append("]]>");
                details.append(isError ? "</error>" : "</failure>").append("</testcase>");
                continue;
            }
            details.append("/>");
        }
        details.append("</tests-details>");
        context.saveMeasure((Resource)this.getUnitTestResource(fileReport, project), new Measure(CoreMetrics.TEST_DATA, details.toString()));
    }
}

