/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.sensor;

import com.thoughtworks.xstream.XStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.php.core.Php;
import org.sonar.plugins.php.core.executor.PhpPluginExecutionException;
import org.sonar.plugins.php.phpunit.configuration.PhpUnitConfiguration;
import org.sonar.plugins.php.phpunit.sensor.PhpUnitCoverageResultParser;
import org.sonar.plugins.php.phpunit.sensor.PhpUnitExecutor;
import org.sonar.plugins.php.phpunit.sensor.PhpUnitResultParser;

public class PhpUnitSensor
implements Sensor {
    private PhpUnitConfiguration config;
    private static final Logger LOG = LoggerFactory.getLogger(PhpUnitSensor.class);

    public void analyse(Project project, SensorContext context) {
        try {
            if (!this.getConfig(project).isAnalyseOnly()) {
                PhpUnitExecutor executor = new PhpUnitExecutor(this.config, project);
                executor.execute();
            }
            PhpUnitResultParser parser = new PhpUnitResultParser(project, context);
            parser.parse(this.config.getReportFile());
            if (this.config.shouldRunCoverage()) {
                new PhpUnitCoverageResultParser(project, context).parse(this.config.getCoverageReportFile());
            }
        }
        catch (XStreamException e) {
            LOG.error("Report file is invalid, plugin will stop.", (Throwable)e);
            throw new SonarException((Throwable)e);
        }
        catch (PhpPluginExecutionException e) {
            LOG.error("Error occured while launching PhpUnit", (Throwable)e);
            throw new SonarException((Throwable)e);
        }
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.getConfig(project).isShouldRun() && Php.INSTANCE.equals((Object)project.getLanguage());
    }

    private PhpUnitConfiguration getConfig(Project project) {
        if (this.config == null) {
            this.config = new PhpUnitConfiguration(project);
        }
        return this.config;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

