/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.apache.commons.lang.StringUtils;

@XStreamAlias(value="testcase")
public final class TestCase {
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_FAILURE = "failure";
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SKIPPED = "skipped";
    @XStreamAsAttribute
    private int assertions;
    @XStreamAsAttribute
    @XStreamAlias(value="class")
    private String className;
    @XStreamAsAttribute
    private String errorMessage;
    @XStreamAsAttribute
    private String file;
    @XStreamAsAttribute
    private int line;
    @XStreamAsAttribute
    private String name;
    @XStreamOmitField
    private String status;
    @XStreamAsAttribute
    private double time;
    @XStreamAlias(value="error")
    private String error;
    @XStreamAlias(value="failure")
    private String failure;

    public TestCase(int assertions, String className, String errorMessage, String file, int line, String name, String status, String error, String failure, double time) {
        this.assertions = assertions;
        this.className = className;
        this.errorMessage = errorMessage;
        this.file = file;
        this.line = line;
        this.name = name;
        this.status = status;
        this.error = error;
        this.failure = failure;
        this.time = time;
    }

    public int getAssertions() {
        return this.assertions;
    }

    public String getClassName() {
        return this.className;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFailure() {
        return this.failure;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public String getName() {
        return this.name;
    }

    public String getStackTrace() {
        if (STATUS_ERROR.equals(this.getStatus())) {
            return this.error;
        }
        if (STATUS_FAILURE.equals(this.getStatus())) {
            return this.failure;
        }
        return null;
    }

    public String getStatus() {
        if (StringUtils.isBlank((String)this.status)) {
            this.status = STATUS_OK;
        }
        if (StringUtils.isNotBlank((String)this.error)) {
            this.status = STATUS_ERROR;
        }
        if (StringUtils.isNotBlank((String)this.failure)) {
            this.status = STATUS_FAILURE;
        }
        return this.status;
    }

    public double getTime() {
        return this.time;
    }

    public void setAssertions(int assertions) {
        this.assertions = assertions;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setFailure(String failure) {
        this.failure = failure;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTime(double time) {
        this.time = time;
    }
}

