/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.graph.DsmCell;
import org.sonar.graph.Edge;

public class Dsm<V> {
    private final V[] vertices;
    private final DsmCell[][] cells;
    private final int dimension;
    private final DirectedGraphAccessor<V, ? extends Edge<V>> graph;
    private boolean atLeastOneDependency = false;

    public Dsm(DirectedGraphAccessor<V, ? extends Edge<V>> graph, Collection<V> vertices, Set<Edge> feedbackEdges) {
        this.graph = graph;
        this.dimension = vertices.size();
        this.vertices = this.initVertices(vertices);
        this.cells = this.initCells(feedbackEdges);
    }

    public Dsm(DirectedGraphAccessor<V, ? extends Edge<V>> acyclicGraph, Set<Edge> feedbackEdges) {
        this(acyclicGraph, acyclicGraph.getVertices(), feedbackEdges);
    }

    public Dsm(DirectedGraphAccessor<V, ? extends Edge<V>> acyclicGraph) {
        this(acyclicGraph, acyclicGraph.getVertices(), Collections.emptySet());
    }

    private DsmCell[][] initCells(Set<Edge> feedbackEdges) {
        DsmCell[][] result = new DsmCell[this.dimension][this.dimension];
        for (int x = 0; x < this.dimension; ++x) {
            for (int y = 0; y < this.dimension; ++y) {
                V from = this.vertices[x];
                V to = this.vertices[y];
                Edge<V> edge = this.graph.getEdge(from, to);
                if (edge == null) continue;
                this.atLeastOneDependency = true;
                boolean isFeedbackEdge = feedbackEdges.contains(edge);
                result[x][y] = new DsmCell(edge, isFeedbackEdge);
            }
        }
        return result;
    }

    private V[] initVertices(Collection<V> verticesCol) {
        Object[] result = new Object[this.dimension];
        int i = 0;
        for (V vertex : verticesCol) {
            result[i] = vertex;
            ++i;
        }
        return result;
    }

    public V getVertex(int rowIndex) {
        return this.vertices[rowIndex];
    }

    public int getDimension() {
        return this.dimension;
    }

    public void permute(int fromIndex, int toIndex) {
        if (fromIndex != toIndex) {
            this.checkIndicesBoudaries(fromIndex, toIndex);
            this.permuteVertice(fromIndex, toIndex);
            this.permuteColumns(fromIndex, toIndex);
            this.permuteRows(fromIndex, toIndex);
        }
    }

    private void checkIndicesBoudaries(int ... indices) {
        for (int index : indices) {
            if (index >= 0 && index < this.dimension) continue;
            StringBuilder builder = new StringBuilder("DSM contains the following vertices : ");
            for (V vertex : this.vertices) {
                builder.append(vertex.toString()).append(" | ");
            }
            builder.append(". Trying to reach index ").append(index);
            throw new ArrayIndexOutOfBoundsException(builder.toString());
        }
    }

    private void permuteVertice(int fromIndex, int toIndex) {
        V toVertex;
        V fromVertex = this.vertices[fromIndex];
        this.vertices[fromIndex] = toVertex = this.vertices[toIndex];
        this.vertices[toIndex] = fromVertex;
    }

    private void permuteRows(int fromYIndex, int toYIndex) {
        for (int x = 0; x < this.dimension; ++x) {
            this.permuteCells(x, fromYIndex, x, toYIndex);
        }
    }

    private void permuteColumns(int fromXIndex, int toXIndex) {
        for (int y = 0; y < this.dimension; ++y) {
            this.permuteCells(fromXIndex, y, toXIndex, y);
        }
    }

    private void permuteCells(int fromXIndex, int fromYIndex, int toXIndex, int toYIndex) {
        DsmCell fromCell = this.cells[fromXIndex][fromYIndex];
        DsmCell toCell = this.cells[toXIndex][toYIndex];
        this.cells[toXIndex][toYIndex] = fromCell;
        this.cells[fromXIndex][fromYIndex] = toCell;
    }

    public int getNumberOfIncomingEdges(int y, int from, int to) {
        int incomingEdges = 0;
        for (int x = from; x <= to; ++x) {
            DsmCell cell = this.cells[x][y];
            if (cell == null || cell.getWeight() == 0 || cell.isFeedbackEdge()) continue;
            ++incomingEdges;
        }
        return incomingEdges;
    }

    public int getNumberOfOutgoingEdges(int x, int from, int to) {
        int outgoingEdges = 0;
        for (int y = from; y <= to; ++y) {
            DsmCell cell = this.cells[x][y];
            if (cell == null || cell.getWeight() == 0 || cell.isFeedbackEdge()) continue;
            ++outgoingEdges;
        }
        return outgoingEdges;
    }

    @Deprecated
    public DsmCell getCell(int x, int y) {
        DsmCell cell = this.cells[x][y];
        return cell != null ? cell : new DsmCell(null, false);
    }

    @CheckForNull
    public DsmCell cell(int x, int y) {
        return this.cells[x][y];
    }

    public boolean hasAtLeastOneDependency() {
        return this.atLeastOneDependency;
    }

    public V[] getVertices() {
        Object[] verticesCopy = new Object[this.vertices.length];
        System.arraycopy(this.vertices, 0, verticesCopy, 0, this.vertices.length);
        return verticesCopy;
    }
}

