/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.StreamLoader;
import com.persistit.StreamSaver;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.DuplicateKeyException;
import com.persistit.exception.PersistitException;
import com.persistit.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class TreeBuilder {
    private static final float DEFAULT_BUFFER_POOL_FRACTION = 0.5f;
    private static final long REPORT_REPORT_MULTIPLE = 1000000L;
    private static final String SDF = "yyyyMMddHHmm";
    private static final int STREAM_SIZE = 0x100000;
    private final String _name;
    private final long _uniqueId;
    private final Persistit _persistit;
    private final List<File> _directories = new ArrayList<File>();
    private final int _pageSize;
    private final int _pageLimit;
    private final AtomicLong _sortedKeyCount = new AtomicLong();
    private final AtomicLong _mergedKeyCount = new AtomicLong();
    private volatile long _reportKeyCountMultiple = 1000000L;
    private Volume _sortVolume;
    private File _sortFile;
    private final List<Tree> _allTrees = new ArrayList<Tree>();
    private final Map<String, Tree> _sortTreeMap = new HashMap<String, Tree>();
    private int _sortFileIndex;
    private final List<Node> _sortNodes = new ArrayList<Node>();
    private final ThreadLocal<Map<Tree, Exchange>> _sortExchangeMapThreadLocal = new ThreadLocal<Map<Tree, Exchange>>(){

        @Override
        public Map<Tree, Exchange> initialValue() {
            return new HashMap<Tree, Exchange>();
        }
    };
    private final Comparator<Tree> _defaultTreeComparator = new Comparator<Tree>(){

        @Override
        public int compare(Tree a, Tree b) {
            if (a == b) {
                return 0;
            }
            return TreeBuilder.this._allTrees.indexOf(a) - TreeBuilder.this._allTrees.indexOf(b);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    };

    public TreeBuilder(Persistit persistit) {
        this(persistit, new SimpleDateFormat(SDF).format(new Date()), -1, 0.5f);
    }

    public TreeBuilder(Persistit persistit, String name, int pageSize, float bufferPoolFraction) {
        this._name = name;
        this._uniqueId = persistit.unique();
        this._persistit = persistit;
        this._pageSize = pageSize == -1 ? this.computePageSize(persistit) : pageSize;
        int bufferCount = this._persistit.getBufferPool(this._pageSize).getBufferCount();
        this._pageLimit = (int)((float)bufferCount * bufferPoolFraction);
    }

    private int computePageSize(Persistit persistit) {
        int pageSize = persistit.getConfiguration().getTmpVolPageSize();
        if (pageSize == 0) {
            for (int size : persistit.getBufferPoolHashMap().keySet()) {
                if (size <= pageSize) continue;
                pageSize = size;
            }
        }
        return pageSize;
    }

    public final String getName() {
        return this._name;
    }

    public final void setReportKeyCountMultiple(long multiple) {
        this._reportKeyCountMultiple = Util.rangeCheck(multiple, 1L, Long.MAX_VALUE);
    }

    public final long getReportKeyCountMultiple() {
        return this._reportKeyCountMultiple;
    }

    public final synchronized int getSortFileCount() {
        return this._sortFileIndex;
    }

    public long getSortedKeyCount() {
        return this._sortedKeyCount.get();
    }

    public long getMergedKeyCount() {
        return this._mergedKeyCount.get();
    }

    public final synchronized List<Tree> getTrees() {
        ArrayList<Tree> list = new ArrayList<Tree>(this._allTrees);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSortTreeDirectories(List<File> directories) throws IOException {
        if (directories == null || directories.isEmpty()) {
            TreeBuilder treeBuilder = this;
            synchronized (treeBuilder) {
                this._directories.clear();
            }
        }
        for (File file : directories) {
            if (!file.exists() || file.isDirectory()) continue;
            throw new IllegalArgumentException(file + " is not a directory");
        }
        for (File file : directories) {
            if (file.exists() || file.mkdirs()) continue;
            throw new IllegalArgumentException(file + " could not be created as a new directory");
        }
        for (File file : directories) {
            File temp = File.createTempFile("persistit_tempvol_", null, file);
            temp.delete();
        }
        TreeBuilder treeBuilder = this;
        synchronized (treeBuilder) {
            this._directories.clear();
            this._directories.addAll(directories);
            this._sortFileIndex = 0;
        }
    }

    public final List<File> getSortFileDirectories() {
        return Collections.unmodifiableList(this._directories);
    }

    public final void store(Exchange exchange) throws Exception {
        this.store(exchange.getTree(), exchange.getKey(), exchange.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(Tree tree, Key key, Value value) throws Exception {
        long count;
        Map<Tree, Exchange> map = this._sortExchangeMapThreadLocal.get();
        Exchange ex = map.get(tree);
        if (ex == null || ex.getTree().getVolume().getNextAvailablePage() > (long)this._pageLimit) {
            Volume newSortVolume = this.getSortVolume();
            String tempTreeName = "_" + this._persistit.getJournalManager().handleForTree(tree);
            ex = this._persistit.getExchange(newSortVolume, tempTreeName, true);
            map.put(tree, ex);
            TreeBuilder treeBuilder = this;
            synchronized (treeBuilder) {
                if (!this._allTrees.contains(tree)) {
                    this._allTrees.add(tree);
                    this._sortTreeMap.put(tempTreeName, tree);
                }
            }
        }
        key.copyTo(ex.getKey());
        value.copyTo(ex.getValue());
        ex.fetchAndStore();
        boolean stored = true;
        if (ex.getValue().isDefined() && !this.duplicateKeyDetected(ex.getTree(), ex.getKey(), ex.getValue(), value)) {
            stored = false;
            ex.store();
        }
        if (stored && (count = this._sortedKeyCount.incrementAndGet()) % this._reportKeyCountMultiple == 0L) {
            this.reportSorted(count);
        }
    }

    private void insertNode(Map<Node, Node> sorted, Node node) throws Exception {
        Node other = sorted.put(node, node);
        if (other != null) {
            boolean reverse;
            if (node._precedence < other._precedence) {
                reverse = this.duplicateKeyDetected(node._tree, node._key, node._value, other._value);
            } else {
                boolean bl = reverse = !this.duplicateKeyDetected(node._tree, node._key, other._value, node._value);
            }
            if (reverse) {
                sorted.put(node, other);
                Node p = other._duplicate;
                other._duplicate = node;
                node._duplicate = p;
            } else {
                node._duplicate = other;
            }
        }
    }

    public synchronized void merge() throws Exception {
        this.finishSortVolume();
        if (this._mergedKeyCount.get() % this._reportKeyCountMultiple != 0L) {
            this.reportSorted(this._mergedKeyCount.get());
        }
        Tree currentTree = null;
        Exchange ex = null;
        TreeMap<Node, Node> sorted = new TreeMap<Node, Node>();
        for (Node node : this._sortNodes) {
            node.createStreamLoader();
            if (!node.next()) continue;
            this.insertNode(sorted, node);
        }
        while (!sorted.isEmpty()) {
            Node node = (Node)sorted.firstKey();
            if ((node = (Node)sorted.remove(node))._tree != currentTree) {
                ex = new Exchange(node._tree);
                currentTree = node._tree;
            }
            node._key.copyTo(ex.getKey());
            node._value.copyTo(ex.getValue());
            if (this.beforeMergeKey(ex)) {
                ex.fetchAndStore();
                boolean stored = true;
                if (ex.getValue().isDefined() && !this.duplicateKeyDetected(ex.getTree(), ex.getKey(), ex.getValue(), node._value)) {
                    ex.store();
                    stored = false;
                }
                if (stored) {
                    this.afterMergeKey(ex);
                    if (this._mergedKeyCount.incrementAndGet() % this._reportKeyCountMultiple == 0L) {
                        this.reportMerged(this._mergedKeyCount.get());
                    }
                }
            }
            while (node != null) {
                Node next = node._duplicate;
                node._duplicate = null;
                if (node.next()) {
                    this.insertNode(sorted, node);
                }
                node = next;
            }
        }
        if (this._mergedKeyCount.get() % this._reportKeyCountMultiple != 0L) {
            this.reportMerged(this._mergedKeyCount.get());
        }
        this.reset();
    }

    private synchronized void reset() throws Exception {
        Exception exception;
        block7: {
            exception = null;
            try {
                if (this._sortVolume != null) {
                    this._sortVolume.close();
                }
            }
            catch (PersistitException e) {
                if (exception != null) break block7;
                exception = e;
            }
        }
        for (Node node : this._sortNodes) {
            try {
                if (node.getFile() == null) continue;
                node.getFile().delete();
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        this._allTrees.clear();
        this._sortNodes.clear();
        this._sortVolume = null;
        this._sortFileIndex = 0;
        this._sortExchangeMapThreadLocal.get().clear();
        if (exception != null) {
            throw exception;
        }
    }

    public void clear() throws Exception {
        this._sortedKeyCount.set(0L);
        this._mergedKeyCount.set(0L);
        this.reset();
    }

    private synchronized Volume getSortVolume() throws Exception {
        if (this._sortVolume != null && this._sortVolume.getNextAvailablePage() > (long)this._pageLimit) {
            this.finishSortVolume();
        }
        if (this._sortVolume == null) {
            File directory;
            if (this._directories.isEmpty()) {
                String directoryName = this._persistit.getConfiguration().getTmpVolDir();
                if (directoryName == null) {
                    directoryName = System.getProperty("java.io.tmpdir");
                }
                if (!(directory = new File(directoryName)).exists()) {
                    directory.mkdirs();
                }
                this._directories.add(directory);
            } else {
                directory = this._directories.get(this._sortFileIndex % this._directories.size());
            }
            this._sortVolume = Volume.createTemporaryVolume(this._persistit, this._pageSize, directory);
            this._sortFile = new File(directory, String.format("%s_%d.%06d", this._name, this._uniqueId, this._sortFileIndex));
            Node node = new Node(this._sortFile, this._sortFileIndex);
            this._sortNodes.add(node);
            ++this._sortFileIndex;
        }
        return this._sortVolume;
    }

    private void finishSortVolume() throws Exception {
        if (this._sortVolume != null) {
            this.beforeSortVolumeClosed(this._sortVolume, this._sortFile);
            this.saveSortVolume(this._sortVolume, this._sortFile);
            this.afterSortVolumeClose(this._sortVolume, this._sortFile);
            this._sortVolume.close();
            this._sortVolume = null;
        }
    }

    private void saveSortVolume(Volume volume, File file) throws Exception {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 0x100000));
        ArrayList<Tree> sorted = new ArrayList<Tree>(this._allTrees);
        Collections.sort(sorted, this.getTreeComparator());
        SortStreamSaver saver = new SortStreamSaver(this._persistit, dos);
        for (Tree tree : sorted) {
            String sortTreeName = "_" + tree.getHandle();
            Tree sortTree = volume.getTree(sortTreeName, false);
            if (sortTree == null) continue;
            Exchange exchange = new Exchange(sortTree);
            saver.save(exchange, null);
        }
        file.deleteOnExit();
        dos.close();
    }

    protected void beforeSortVolumeClosed(Volume volume, File file) throws Exception {
    }

    protected void afterSortVolumeClose(Volume volume, File file) throws Exception {
    }

    protected boolean duplicateKeyDetected(Tree tree, Key key, Value v1, Value v2) throws Exception {
        throw new DuplicateKeyException(String.format("Tree=%s Key=%s", tree, key));
    }

    protected boolean beforeMergeKey(Exchange exchange) throws Exception {
        return true;
    }

    protected void afterMergeKey(Exchange exchange) throws Exception {
    }

    protected void reportSorted(long count) {
    }

    protected void reportMerged(long count) {
    }

    protected Comparator<Tree> getTreeComparator() {
        return this._defaultTreeComparator;
    }

    void unitTestNextSortFile() throws Exception {
        this.finishSortVolume();
        this._sortExchangeMapThreadLocal.get().clear();
        this._sortVolume = null;
    }

    private class SortStreamSaver
    extends StreamSaver {
        Tree _sortTree;

        SortStreamSaver(Persistit persistit, DataOutputStream stream) {
            super(persistit, stream);
            this._sortTree = null;
        }

        @Override
        protected void writeData(Exchange exchange) throws IOException {
            if (exchange.getTree() != this._sortTree) {
                Tree source = (Tree)TreeBuilder.this._sortTreeMap.get(exchange.getTree().getName());
                if (this._lastVolume != source.getVolume()) {
                    this.writeVolumeInfo(source.getVolume());
                    this._lastVolume = source.getVolume();
                }
                if (this._lastTree != source) {
                    this.writeTreeInfo(source);
                    this._lastTree = source;
                }
            }
            this.writeData(exchange.getKey(), exchange.getValue());
            ++this._recordCount;
        }
    }

    private class Node
    implements Comparable<Node> {
        private Tree _tree;
        private Key _key;
        private Value _value;
        private Node _duplicate;
        private final int _precedence;
        private final File _file;
        private StreamLoader _loader;
        private Handler _handler;
        private boolean _next;

        private File getFile() {
            return this._file;
        }

        private Node(File file, int index) {
            this._file = file;
            this._precedence = index;
        }

        @Override
        public int compareTo(Node node) {
            if (this._tree == null) {
                return node._tree == null ? 0 : 1;
            }
            if (node._tree == null) {
                return -1;
            }
            if (this._tree != node._tree) {
                return TreeBuilder.this._allTrees.indexOf(this._tree) - TreeBuilder.this._allTrees.indexOf(node._tree);
            }
            return this._key.compareTo(node._key);
        }

        public String toString() {
            Node n = this;
            StringBuilder sb = new StringBuilder();
            while (n != null) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (n._tree == null) {
                    sb.append("<end>");
                } else {
                    sb.append("<" + n._tree.getName() + n._key + "=" + n._value + ">");
                }
                n = n._duplicate;
            }
            return sb.toString();
        }

        private void createStreamLoader() throws Exception {
            this._loader = new StreamLoader(TreeBuilder.this._persistit, new DataInputStream(new BufferedInputStream(new FileInputStream(this._file), 0x100000)));
            this._handler = new Handler(TreeBuilder.this._persistit);
        }

        private boolean next() throws Exception {
            this._next = false;
            while (this._loader.next(this._handler) && !this._next) {
            }
            if (!this._next) {
                this._loader.close();
            }
            return this._next;
        }

        private class Handler
        extends StreamLoader.ImportHandler {
            private Handler(Persistit persistit) {
                super(persistit);
            }

            @Override
            protected void handleDataRecord(Key key, Value value) throws PersistitException {
                Node.this._tree = this._tree;
                Node.this._key = key;
                Node.this._value = value;
                Node.this._next = true;
            }
        }
    }
}

