/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.Persistit;
import com.persistit.SharedResource;
import com.persistit.Volume;
import com.persistit.exception.InUseException;
import com.persistit.exception.InvalidPageAddressException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.VolumeClosedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;

abstract class VolumeStorage
extends SharedResource {
    private static final Random ID_GENERATOR = new Random();
    protected Volume _volume;

    protected static long generateId() {
        return (ID_GENERATOR.nextLong() & 0xFFFFFFFFFFL) + 1L;
    }

    VolumeStorage(Persistit persistit, Volume volume) {
        super(persistit);
        this._volume = volume;
    }

    String getPath() {
        return this._volume.getSpecification().getPath();
    }

    boolean isReadOnly() {
        return this._volume.getSpecification().isReadOnly();
    }

    abstract boolean isTemp();

    abstract FileChannel getChannel() throws PersistitIOException;

    abstract void create() throws PersistitException;

    abstract void open() throws PersistitException;

    abstract boolean exists() throws PersistitException;

    abstract boolean delete() throws PersistitException;

    abstract void force() throws PersistitIOException;

    abstract void close() throws PersistitException;

    abstract void flush() throws PersistitException;

    abstract void truncate() throws PersistitException;

    abstract boolean isOpened();

    abstract boolean isClosed();

    abstract long getExtentedPageCount();

    abstract long getNextAvailablePage();

    abstract void claimHeadBuffer() throws PersistitException;

    abstract void releaseHeadBuffer();

    abstract void readPage(Buffer var1) throws PersistitIOException, InvalidPageAddressException, VolumeClosedException, InUseException, PersistitInterruptedException;

    abstract void writePage(Buffer var1) throws PersistitException;

    abstract void writePage(ByteBuffer var1, long var2) throws PersistitException;

    abstract long allocNewPage() throws PersistitException;

    abstract void extend(long var1) throws PersistitException;

    abstract void flushMetaData() throws PersistitException;

    abstract boolean updateMetaData(byte[] var1);
}

