/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.Value;
import com.persistit.exception.PersistitException;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PersistitTableModel
extends AbstractTableModel {
    private static final int SCROLL_EXTRA = 100;
    private static final float SCROLL_FACTOR = 1.3f;
    private static final int ROW_CACHE_SIZE = 100;
    private static final int INITIAL_ROW_COUNT_ESTIMATE = 10000;
    private static final String[] COLUMN_HEADER_NAMES = new String[]{"Index", "Key", "Type", "Value"};
    private static final int[] COLUMN_HEADER_WIDTHS = new int[]{50, 450, 50, 450};
    private static final int COLUMN_COUNT = COLUMN_HEADER_NAMES.length;
    private Exchange _exchange;
    private Key _rootKey;
    private final Row _rootRow = new Row(new byte[0]);
    private final RowCache _rowCache = new RowCache();
    private int _rowCountActual;
    private int _rowCountEstimate;
    private int _rowGetValueHits;
    private int _rowGetValueOperations;

    public void setExchange(Exchange exchange) {
        this._exchange = exchange;
        this._rootKey = new Key(this._exchange.getKey());
        this._rowCache.clear();
        this._rowCountActual = -1;
        this._rowCountEstimate = 10000;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Exchange getExchange() {
        return this._exchange;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0) {
            throw new IllegalArgumentException("rowIndex=" + rowIndex);
        }
        if (this._rowCountActual >= 0 && rowIndex > this._rowCountActual) {
            return this._rootRow;
        }
        ++this._rowGetValueOperations;
        try {
            int index;
            Row row = this._rowCache.get(rowIndex);
            if (row != null) {
                ++this._rowGetValueHits;
                return row;
            }
            int minCachedIndex = this._rowCache.getFirstIndex();
            int maxCachedIndex = this._rowCache.getLastIndex();
            if (rowIndex < minCachedIndex) {
                if (rowIndex > minCachedIndex / 2) {
                    row = this._rowCache.get(minCachedIndex);
                    int index2 = minCachedIndex;
                    while (index2 > rowIndex) {
                        if (row == null) {
                            return null;
                        }
                        row = row.getNextRow(false);
                        --index2;
                        if (row == null) {
                            row = this._rootRow;
                        }
                        this._rowCache.put(index2, row);
                    }
                    return row;
                }
                maxCachedIndex = 0;
                minCachedIndex = 0;
            }
            if (maxCachedIndex == 0) {
                index = 0;
                row = this._rootRow;
                if (rowIndex == 0) {
                    this._rowCache.put(index, row);
                }
            } else {
                index = maxCachedIndex - 1;
                row = this._rowCache.get(index);
            }
            while (index < rowIndex) {
                if (row == null) {
                    return null;
                }
                row = row.getNextRow(true);
                ++index;
                if (row == null) {
                    boolean changed = index != this._rowCountEstimate;
                    int previousEstimate = this._rowCountEstimate;
                    this._rowCountEstimate = index;
                    this._rowCountActual = index;
                    if (changed) {
                        this.fireSizeChanged(previousEstimate);
                    }
                    return null;
                }
                this._rowCache.put(index, row);
            }
            if (this._rowCountActual < 0 && this._rowCountEstimate - rowIndex < 100) {
                int previousEstimate = this._rowCountEstimate;
                this._rowCountEstimate = (int)((float)(this._rowCountEstimate + 100) * 1.3f);
                this.fireSizeChanged(previousEstimate);
            }
            return row;
        }
        catch (PersistitException de) {
            return de;
        }
    }

    @Override
    public int getRowCount() {
        return this._rowCountEstimate;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public void setupColumns(JTable table) {
        TableColumnModel tcm = table.getColumnModel();
        int count = tcm.getColumnCount();
        String[] headers = COLUMN_HEADER_NAMES;
        int[] widths = COLUMN_HEADER_WIDTHS;
        ExchangeTableCellRenderer renderer = new ExchangeTableCellRenderer();
        for (int i = 0; i < headers.length; ++i) {
            TableColumn tc;
            if (i >= count) {
                tc = new TableColumn();
                tcm.addColumn(tc);
            } else {
                tc = tcm.getColumn(i);
            }
            tc.setHeaderValue(headers[i]);
            tc.setPreferredWidth(widths[i]);
            tc.setCellRenderer(renderer);
        }
    }

    private void fireSizeChanged(int previousEstimate) {
        if (this._rowCountEstimate > previousEstimate) {
            this.fireTableRowsInserted(previousEstimate, this._rowCountEstimate - 1);
        } else if (this._rowCountEstimate < previousEstimate) {
            this.fireTableRowsDeleted(this._rowCountEstimate, previousEstimate - 1);
        }
    }

    public JTable createTreeDisplayTable() {
        TreeDisplayTable tdt = new TreeDisplayTable(this);
        this.setupColumns(tdt);
        return tdt;
    }

    private static class TreeDisplayTable
    extends JTable {
        TreeDisplayTable(PersistitTableModel dtm) {
            super(dtm);
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            String s;
            TableCellRenderer tcr;
            Component rc;
            Object value;
            int row = this.rowAtPoint(me.getPoint());
            int col = this.columnAtPoint(me.getPoint());
            if (row >= 0 && col >= 0 && (value = this.getModel().getValueAt(row, col)) != null && (rc = (tcr = this.getCellRenderer(row, col)).getTableCellRendererComponent(this, value, false, false, row, col)) instanceof JLabel && (s = ((JLabel)rc).getText()).length() > 20) {
                return s;
            }
            return null;
        }
    }

    private static class ExchangeTableCellRenderer
    extends DefaultTableCellRenderer {
        private ExchangeTableCellRenderer() {
            this.setFont(new Font("Lucida", 0, 13));
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            Row row = (Row)value;
            if (row == null) {
                label.setText("");
            } else {
                switch (columnIndex) {
                    case 0: {
                        label.setText(Integer.toString(rowIndex));
                        label.setHorizontalAlignment(4);
                        break;
                    }
                    case 1: {
                        label.setText(row.getKeyString());
                        label.setHorizontalAlignment(2);
                        break;
                    }
                    case 2: {
                        label.setText(row.getValueTypeString());
                        label.setHorizontalAlignment(0);
                        break;
                    }
                    case 3: {
                        label.setText(row.getValueString());
                        label.setHorizontalAlignment(2);
                        break;
                    }
                    default: {
                        label.setText("Unknown column " + columnIndex);
                    }
                }
            }
            return label;
        }

        @Override
        protected void setValue(Object value) {
        }
    }

    private static class RowCache {
        private final Row[] _cache = new Row[100];
        private int _tail = 0;
        private int _head = 0;
        private int _firstCachedIndex = 0;

        private RowCache() {
        }

        private void clear() {
            this._tail = 0;
            this._head = 0;
            for (int index = 0; index < 100; ++index) {
                this._cache[index] = null;
            }
        }

        private int getFirstIndex() {
            return this._firstCachedIndex;
        }

        private int getLastIndex() {
            return this._firstCachedIndex + this.size();
        }

        private int size() {
            int size = this._head - this._tail;
            if (size < 0) {
                size += 100;
            }
            return size;
        }

        private Row get(int index) {
            if ((index -= this._firstCachedIndex) < 0) {
                return null;
            }
            if (index >= this.size()) {
                return null;
            }
            index = (index + this._tail) % 100;
            return this._cache[index];
        }

        private void put(int index, Row row) {
            row._index = index;
            int size = this.size();
            if ((index -= this._firstCachedIndex) == -1) {
                --this._tail;
                if (this._tail < 0) {
                    this._tail += 100;
                }
                if (this._head == this._tail) {
                    --this._head;
                    if (this._head < 0) {
                        this._head += 100;
                    }
                }
                --this._firstCachedIndex;
                this._cache[this._tail] = row;
            } else if (index == size) {
                this._cache[this._head] = row;
                ++this._head;
                if (this._head == 100) {
                    this._head = 0;
                }
                if (this._head == this._tail) {
                    this._cache[this._tail] = null;
                    ++this._tail;
                    if (this._tail == 100) {
                        this._tail = 0;
                    }
                    ++this._firstCachedIndex;
                }
            } else if (index >= 0 && index < size) {
                if ((index -= this._tail) < 0) {
                    index += 100;
                }
                this._cache[index] = row;
            } else {
                this.clear();
                this._cache[0] = row;
                ++this._head;
                this._firstCachedIndex += index;
            }
        }
    }

    private class Row {
        private final byte[] _keyBytes;
        private int _index = -1;

        private Row(byte[] keyBytes) {
            this._keyBytes = keyBytes;
        }

        private boolean isExpanded() {
            return true;
        }

        private Row getNextRow(boolean forward) throws PersistitException {
            boolean expanded;
            Exchange ex = this.setupExchange();
            if (!ex.traverse(forward ? Key.GT : Key.LT, expanded = this.isExpanded())) {
                return null;
            }
            Key key = ex.getKey();
            if (key.compareKeyFragment(PersistitTableModel.this._rootKey, 0, PersistitTableModel.this._rootKey.getEncodedSize()) != 0) {
                return null;
            }
            int keyBytesSize = key.getEncodedSize() - PersistitTableModel.this._rootKey.getEncodedSize();
            byte[] keyBytes = new byte[keyBytesSize];
            System.arraycopy(key.getEncodedBytes(), PersistitTableModel.this._rootKey.getEncodedSize(), keyBytes, 0, keyBytesSize);
            return new Row(keyBytes);
        }

        private String getValueTypeString() {
            try {
                Exchange ex = this.setupExchange();
                if (ex.getKey().getEncodedSize() == 0) {
                    return "";
                }
                ex.fetch();
                Value value = ex.getValue();
                if (!value.isDefined()) {
                    return "undefined";
                }
                return value.getType().getName();
            }
            catch (PersistitException de) {
                return de.toString();
            }
        }

        private String getValueString() {
            try {
                Exchange ex = this.setupExchange();
                if (ex.getKey().getEncodedSize() == 0) {
                    return "";
                }
                ex.fetch();
                Value value = ex.getValue();
                if (value.getEncodedSize() > 50000) {
                    return "Too long to display: " + value.getEncodedSize();
                }
                return value.toString();
            }
            catch (PersistitException de) {
                return de.toString();
            }
        }

        private Key getKey() {
            Exchange ex = this.setupExchange();
            return ex.getKey();
        }

        private Value getValue() throws PersistitException, IOException {
            Exchange ex = this.setupExchange();
            ex.fetch();
            return ex.getValue();
        }

        private String getKeyString() {
            Exchange ex = this.setupExchange();
            ex.getKey().setIndex(0);
            return ex.getKey().toString();
        }

        private Exchange setupExchange() {
            Exchange ex = PersistitTableModel.this.getExchange();
            Key key = ex.getKey();
            System.arraycopy(PersistitTableModel.this._rootKey.getEncodedBytes(), 0, key.getEncodedBytes(), 0, PersistitTableModel.this._rootKey.getEncodedSize());
            System.arraycopy(this._keyBytes, 0, key.getEncodedBytes(), PersistitTableModel.this._rootKey.getEncodedSize(), this._keyBytes.length);
            key.setEncodedSize(PersistitTableModel.this._rootKey.getEncodedSize() + this._keyBytes.length);
            return ex;
        }

        public String toString() {
            return this._index + ": " + this.setupExchange().getKey().toString() + "-->" + this.getValueString();
        }
    }
}

