/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.stax.ElementReader;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.aegis.yom.YOMReader;
import org.codehaus.xfire.aegis.yom.YOMWriter;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessageHeaderInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.yom.Element;

public class AegisBindingProvider
implements BindingProvider {
    public static final String TYPE_MAPPING_KEY = "type.mapping";
    public static final String ENCODING_URI_KEY = "type.encodingUri";
    private TypeMappingRegistry registry;
    private boolean writeOuter = true;

    public AegisBindingProvider() {
        this(new DefaultTypeMappingRegistry(true));
    }

    public AegisBindingProvider(TypeMappingRegistry registry) {
        this.registry = registry;
    }

    public boolean isWriteOuter() {
        return this.writeOuter;
    }

    public void setWriteOuter(boolean writeOuter) {
        this.writeOuter = writeOuter;
    }

    public void initialize(Service endpoint) {
        String encodingStyle = (String)endpoint.getProperty(ENCODING_URI_KEY);
        if (encodingStyle == null) {
            AbstractBinding binding = (AbstractBinding)endpoint.getBinding();
            encodingStyle = binding.getUse().equals("encoded") ? endpoint.getSoapVersion().getSoapEncodingStyle() : "http://www.w3.org/2001/XMLSchema";
        }
        endpoint.setProperty(ENCODING_URI_KEY, (Object)encodingStyle);
        TypeMapping tm = this.registry.createTypeMapping(encodingStyle, true);
        endpoint.setProperty(TYPE_MAPPING_KEY, (Object)tm);
        this.registry.register(endpoint.getServiceInfo().getName().getNamespaceURI(), tm);
        Iterator itr = endpoint.getServiceInfo().getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo opInfo = (OperationInfo)itr.next();
            try {
                this.initializeMessage(endpoint, (MessagePartContainer)opInfo.getInputMessage());
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing parameters for method " + opInfo.getMethod());
                throw e;
            }
            try {
                this.initializeMessage(endpoint, (MessagePartContainer)opInfo.getOutputMessage());
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing return value for method " + opInfo.getMethod());
                throw e;
            }
        }
    }

    protected void initializeMessage(Service service, MessagePartContainer container) {
        Iterator itr = container.getMessageHeaders().iterator();
        while (itr.hasNext()) {
            MessageHeaderInfo header = (MessageHeaderInfo)itr.next();
            header.setSchemaType((SchemaType)this.getParameterType(AegisBindingProvider.getTypeMapping(service), header));
        }
        itr = container.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = (MessagePartInfo)itr.next();
            part.setSchemaType((SchemaType)this.getParameterType(AegisBindingProvider.getTypeMapping(service), part));
        }
    }

    public Object readParameter(MessagePartInfo p, XMLStreamReader xsr, MessageContext context) throws XFireFault {
        Type type = (Type)p.getSchemaType();
        ElementReader reader = new ElementReader(xsr);
        return type.readObject(reader, context);
    }

    public void writeParameter(MessagePartInfo p, XMLStreamWriter writer, MessageContext context, Object value) throws XFireFault {
        Type type = (Type)p.getSchemaType();
        ElementWriter mw = this.writeOuter ? new ElementWriter(writer, p.getName()) : new ElementWriter(writer);
        type.writeObject(value, mw, context);
        if (this.writeOuter) {
            mw.close();
        }
    }

    private Type getParameterType(TypeMapping tm, MessagePartInfo param) {
        Type type = tm.getType(param.getName());
        if (type == null && tm.isRegistered(param.getTypeClass())) {
            type = tm.getType(param.getTypeClass());
        }
        if (type == null) {
            OperationInfo op = param.getContainer().getOperation();
            int index = -1;
            if (op.getInputMessage().getMessageParts().contains(param)) {
                index = param.getIndex();
            }
            type = tm.getTypeCreator().createType(op.getMethod(), index);
            type.setTypeMapping(tm);
        }
        return type;
    }

    private Type getParameterType(TypeMapping tm, MessageHeaderInfo param) {
        Type type = tm.getType(param.getName());
        if (type == null && tm.isRegistered(param.getTypeClass())) {
            type = tm.getType(param.getTypeClass());
        }
        if (type == null) {
            OperationInfo op = param.getContainer().getOperation();
            int index = -1;
            if (op.getInputMessage().getMessageHeaders().contains(param)) {
                index = param.getIndex();
            }
            type = tm.getTypeCreator().createType(op.getMethod(), index);
            type.setTypeMapping(tm);
        }
        return type;
    }

    public static TypeMapping getTypeMapping(Service service) {
        return (TypeMapping)service.getProperty(TYPE_MAPPING_KEY);
    }

    public Object readHeader(MessageHeaderInfo p, MessageContext context) throws XFireFault {
        Type type = (Type)p.getSchemaType();
        QName name = p.getName();
        Element headers = context.getExchange().getInMessage().getHeader();
        Element header = headers.getFirstChildElement(name.getLocalPart(), name.getNamespaceURI());
        if (header == null) {
            return null;
        }
        return type.readObject(new YOMReader(header), context);
    }

    public void writeHeader(MessagePartInfo p, MessageContext context, Object value) throws XFireFault {
        Type type = (Type)p.getSchemaType();
        YOMWriter mw = new YOMWriter(context.getOutMessage().getHeader());
        type.writeObject(value, mw, context);
        mw.close();
    }
}

